

#include "shareddir.h"
#include "processoptions.h"

#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>

SharedDir::SharedDir( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this, 1, 1, 0, 5 );

    QHBoxLayout *box = new QHBoxLayout( );
    grid->addLayout( box, 0, 0 );

    cMode = new QComboBox(this);
    cMode->insertItem(i18n("Source directory"));
    cMode->insertItem(i18n("Shared directory"));
    cMode->insertItem(i18n("Directory by metadata"));
    cMode->insertItem(i18n("Copy directory structure"));
    QToolTip::add( cMode, i18n("Output all converted files into...") );
    box->addWidget(cMode);
    pModeInfo = new QPushButton(" ",this,"pModeInfo");
    pModeInfo->setPixmap( KGlobal::iconLoader()->loadIcon("messagebox_info",KIcon::Toolbar) );
    box->addWidget(pModeInfo);
    lDir = new QLineEdit( this, "lDir" );
    box->addWidget(lDir);
    pDirSelect = new QPushButton(" ",this,"pDirSelect");
    pDirSelect->setPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Toolbar) );
    QToolTip::add( pDirSelect, i18n("Select an output directory.") );
    box->addWidget(pDirSelect);
    pDirGoto = new QPushButton(" ",this,"pDirGoto");
    pDirGoto->setPixmap( KGlobal::iconLoader()->loadIcon("konqueror",KIcon::Toolbar) );
    QToolTip::add( pDirGoto, i18n("Open konqueror with the directory.") );
    box->addWidget(pDirGoto);
    pDirInfo = new QPushButton(" ",this,"pDirInfo");
    pDirInfo->setPixmap( KGlobal::iconLoader()->loadIcon("messagebox_info",KIcon::Toolbar) );
    box->addWidget(pDirInfo);

    box->addSpacing( 10 );

    connect( cMode, SIGNAL(activated(int)), this, SLOT(modeChanged(int)) );
    connect( pModeInfo, SIGNAL(clicked()), this, SLOT(modeInfo()) );
    connect( pDirSelect, SIGNAL(clicked()), this, SLOT(selectDir()) );
    connect( pDirGoto, SIGNAL(clicked()), this, SLOT(gotoDir()) );
    connect( pDirInfo, SIGNAL(clicked()), this, SLOT(dirInfo()) );

    modeChanged(0);
}

SharedDir::~SharedDir()
{
}

void SharedDir::selectDir()
{
    QString startDir = lDir->text();
    startDir.append("/");
    int i = startDir.find(QRegExp("%[aAbBcCgGnNtTyY]{1,1}"));
    i = startDir.findRev("/",i);
    startDir = startDir.left(i);

    QString directory = KFileDialog::getExistingDirectory( startDir, 0, i18n("Choose a shared output directory.") );
    if( !directory.isEmpty() ) {
        if(cMode->currentItem() == 2) {
            QString dir = lDir->text();
            i = dir.find(QRegExp("%[aAbBcCgGnNtTyY]{1,1}"));
            i = dir.findRev("/",i);
            lDir->setText(directory+dir.mid(i));
        }
        else {
            lDir->setText(directory);
        }
    }
}

void SharedDir::gotoDir()
{
    QString dir = lDir->text();
    dir.append("/");
    int i = dir.find(QRegExp("%[aAbBcCgGnNtTyY]{1,1}"));
    i = dir.findRev("/",i);
    dir = dir.left(i);

    kfm.clearArguments();
    kfm << "kfmclient";
    kfm << "openURL";
    kfm << dir;
    kfm.start( KProcess::DontCare );
}

void SharedDir::modeChanged(int mode)
{
    if( mode == 0 ) {
        lDir->setEnabled(false);
        if( lastMode != mode ) {
            lDir->setText("");
        }
        pDirSelect->setEnabled(false);
        pDirGoto->setEnabled(false);
        pDirInfo->hide();
    }
    else if( mode == 1 ) {
        lDir->setEnabled(true);
        if( lastMode != mode ) {
            lDir->setText(QDir::homeDirPath());
        }
        pDirSelect->setEnabled(true);
        pDirGoto->setEnabled(true);
        pDirInfo->hide();
    }
    else if( mode == 2 ) {
        lDir->setEnabled(true);
        if( lastMode != mode ) {
            lDir->setText(QDir::homeDirPath()+"/%g/%a/%b/%a - %n - %t");
        }
        pDirSelect->setEnabled(true);
        pDirGoto->setEnabled(true);
        pDirInfo->show();
    }
    else {
        lDir->setEnabled(true);
        if( lastMode != mode ) {
            lDir->setText(QDir::homeDirPath());
        }
        pDirSelect->setEnabled(true);
        pDirGoto->setEnabled(true);
        pDirInfo->hide();
    }

    lastMode=mode;
}

void SharedDir::conversionStarted()
{
    cMode->setEnabled(false);
    lDir->setEnabled(false);
    pDirSelect->setEnabled(false);
}

void SharedDir::conversionStoped()
{
    cMode->setEnabled(true);
    modeChanged(cMode->currentItem());
}

int SharedDir::mode()
{
    return cMode->currentItem();
}

QString SharedDir::dir()
{
    return lDir->text();
}

QString SharedDir::calcFilename()
{
    QFileInfo file = QFileInfo(actFile.sFilename);
    QDir dir = QDir(QDir::cleanDirPath(lDir->text()));

    switch(cMode->currentItem()) {
        case 1: {
            return dir.path()+"/"+file.fileName();
        }
        case 2: {
            QString path = dir.path();
            QString artist = ( actFile.Tag.sArtist ) ? actFile.Tag.sArtist : i18n("Unknown Artist");
            path.replace("%a",artist);
            QString album = ( actFile.Tag.sAlbum ) ? actFile.Tag.sAlbum : i18n("Unknown Album");
            path.replace("%b",album);
            QString comment = ( actFile.Tag.sComment ) ? actFile.Tag.sComment : i18n("No Comment");
            path.replace("%c",comment);
            QString genre = ( actFile.Tag.sGenre ) ? actFile.Tag.sGenre : i18n("Unknown Genre");
            path.replace("%g",genre);
            char cTrack[16];
            sprintf(cTrack,"%i",actFile.Tag.iTrack);
            QString track = ( cTrack ) ? cTrack : "00";
            path.replace("%n",track);
            QString title = ( actFile.Tag.sTitle ) ? actFile.Tag.sTitle : i18n("Unknown Title");
            path.replace("%t",title);
            char cYear[16];
            sprintf(cYear,"%i",actFile.Tag.iYear);
            QString year = ( cYear ) ? cYear : "0000";
            path.replace("%y",year);
            QFileInfo fileinfo(actFile.sFilename);
            QString filename=fileinfo.fileName();
            filename = filename.left(filename.findRev("."));
            path.replace("%f",filename);
            QString mkDir = path;
            mkDir = mkDir.left(mkDir.findRev("/"));
            QStringList dirs = QStringList::split("/",mkDir);
            mkDir = QString::null;
            for( QStringList::Iterator it=dirs.begin(); it!=dirs.end(); ++it )
            {
                mkDir += "/"+*it;
                dir.setPath(mkDir);
                if(!dir.exists()) dir.mkdir(mkDir);
            }
            return path+"."+file.extension(false);
        }
        case 3: {
            QString path = dir.path();
            QStringList dirs = QStringList::split("/",path+file.dirPath());
            QString mkDir = QString::null;
            for( QStringList::Iterator it=dirs.begin(); it!=dirs.end(); ++it )
            {
                mkDir += "/"+*it;
                dir.setPath(mkDir);
                if(!dir.exists()) dir.mkdir(mkDir);
            }
            return path+file.filePath();
        }
        default: return file.filePath();
    }
}

void SharedDir::modeInfo()
{
    int mode = cMode->currentItem();
    QString sModeString = cMode->currentText();

    if( mode == 0 ) {
        KMessageBox::information( this,
        i18n("This will output each file into the same directory as the original file."),
        QString(i18n("Mode")+": ").append(sModeString) );
    }
    else if( mode == 1 ) {
        KMessageBox::information( this,
        i18n("This will output each file into the directory specified in the editbox behind."),
        QString(i18n("Mode")+": ").append(sModeString) );
    }
    else if( mode == 2 ) {
        KMessageBox::information( this,
        i18n("This will output each file into a directory, which is created based on the metadata in the audio files. Select a directory, where the new directories should be created."),
        QString(i18n("Mode")+": ").append(sModeString) );
    }
    else if( mode == 3 ) {
        KMessageBox::information( this,
        i18n("This will output each file into a directory, which is created based on the name of the original directory. So you can copy a whole directory structure, in one you have the original files, in the other the converted."),
        QString(i18n("Mode")+": ").append(sModeString) );
    }
    else {
        KMessageBox::error( this,
        i18n("This mode (%s) doesn't exist.", sModeString),
        QString(i18n("Mode")+": ").append(sModeString) );
    }
}

void SharedDir::dirInfo()
{
    KMessageBox::information( this,
    i18n("<p>The following strings are space holders, that will be replaced by the information in the metatags.</p><p>%a - Artist<br>%b - Album<br>%c - Comment<br>%g - Genre<br>%n - Track<br>%t - Title<br>%y - Year<br>%f - Original file name<p>"),
    QString(i18n("Legend")) );
}

