

#include "options_simple.h"
#include "config.h"
#include "backend_plugins.h"
#include "tools.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qstring.h>
#include <kmessagebox.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kiconloader.h>

OptionsSimple::OptionsSimple( QWidget *parent, const char *name, int text )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    QHBoxLayout *topBox = new QHBoxLayout( );
    grid->addLayout( topBox, 0, 0 );

    QLabel *lQuality = new QLabel( i18n("Quality")+":", this, "lQuality" );
    topBox->addWidget( lQuality, 0, Qt::AlignVCenter );
    cProfile = new QComboBox( this, "cProfile" );
    sProfile.clear();
    cProfile->insertItem( i18n("Very Low") );
    sProfile.append( "Very Low" );
    cProfile->insertItem( i18n("Low") );
    sProfile.append( "Low" );
    cProfile->insertItem( i18n("Medium") );
    sProfile.append( "Medium" );
    cProfile->insertItem( i18n("High") );
    sProfile.append( "High" );
    cProfile->insertItem( i18n("Very High") );
    sProfile.append( "Very High" );
    cProfile->insertItem( i18n("Lossless") );
    sProfile.append( "Lossless" );
    cProfile->insertItem( i18n("User defined") );
    sProfile.append( "User defined" );
    cProfile->setCurrentItem( profileIndex("Medium") );
    topBox->addWidget( cProfile, 0, Qt::AlignVCenter );
    pProfileInfo = new KPushButton( KGlobal::iconLoader()->loadIcon("messagebox_info",KIcon::Small), i18n("Info..."), this, "pProfileInfo" ); // FIXME "info"
    topBox->addWidget( pProfileInfo, 0, Qt::AlignVCenter );
    topBox->addSpacing( 10 );

    QLabel *lFormat = new QLabel( i18n("Output format")+":", this, "lFormat" );
    topBox->addWidget( lFormat, 0, Qt::AlignVCenter );
    cFormat = new QComboBox( this, "cFormat" );
    topBox->addWidget( cFormat, 0, Qt::AlignVCenter );
    pFormatInfo = new KPushButton( KGlobal::iconLoader()->loadIcon("messagebox_info",KIcon::Small), i18n("Info..."), this, "pFormatInfo" ); // FIXME "info"
    topBox->addWidget( pFormatInfo, 0, Qt::AlignVCenter );
    topBox->addStretch( );

    QHBoxLayout *bottomBox = new QHBoxLayout( );
    grid->addLayout( bottomBox, 1, 0 );

    QLabel *lInfo = new QLabel( 0, this, "lInfo" );
    if( text == 1 )
    {
        lInfo->setText( i18n("Klick on \"Ok\" to add the files to the list in the main window!") );
    }
    else
    {
        lInfo->setText( i18n("Choose your prefered output options and klick on \"Add files...\"!") );
    }
    bottomBox->addWidget( lInfo, 0, Qt::AlignVCenter | Qt::AlignLeft );

    connect( pProfileInfo, SIGNAL(clicked()),
             this, SLOT(profileInfo()) );
    connect( pFormatInfo, SIGNAL(clicked()),
             this, SLOT(formatInfo()) );

    connect( cProfile, SIGNAL(activated(int)),
             this, SLOT(profileChanged()) );
    connect( cFormat, SIGNAL(activated(int)),
             this, SLOT(formatChanged()) );

    profileChanged();
}

OptionsSimple::~OptionsSimple()
{
}

int OptionsSimple::formatIndex( QString string )
{
    return sFormat.findIndex( string );
}

int OptionsSimple::profileIndex( QString string )
{
    return sProfile.findIndex( string );
}

void OptionsSimple::profileInfo()
{
    QString sProfileString = cProfile->currentText();

    if( sProfileString == i18n("Very Low") ) {
        KMessageBox::information( this,
        i18n("This produces soundfiles of a very low quality.\nThat can be useful, if you have a mobile device, where your memory cell is limited. It is not recommended to save your music in this quality without a copy with higher quality.\nIt can also be used to save audio files with voices."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Low") ) {
        KMessageBox::information( this,
        i18n("This produces soundfiles of a low quality.\nThat can be useful if you habe a mobile device where your memory cell is limited. It is not recommend to save your music in this quality without a copy with higher quality."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Medium") ) {
        KMessageBox::information( this,
        i18n("This produces soundfiles of a medium quality.\nIf your disc space is limited, you can use this to save your music."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("High") ) {
        KMessageBox::information( this,
        i18n("This produces soundfiles of a high quality.\nIf you have enough disc space available, you can use this to save your music."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Very High") ) {
        KMessageBox::information( this,
        i18n("This produces soundfiles of a very high quality.\nYou should only use this, if you are a quality freak and have enough disc space available."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Lossless") ) {
        KMessageBox::information( this,
        i18n("This produces files, that have exact the same quality as the input files.\nThis files are very big and definitely only for quality freaks."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("User defined") ) {
        KMessageBox::information( this,
        i18n("You can define your own profile in the \"detailed\" tab."),
        i18n("Profile")+": "+sProfileString );
    }
    else {
        KMessageBox::error( this,
        i18n("This Profile (%s) doesn't exist.", sProfileString),
        i18n("Error") );
    }
}

void OptionsSimple::formatInfo()
{
    QString sFormatString = cFormat->currentText();

    if( sFormatString == "wav" ) {
        KMessageBox::information( this,
        i18n("<p>Wave is a file format, that doesn't compress it's audio data.</p>\n<p>So the quality is very high, but the file size is enormous. It is widely spread and should work with every audio player.</p>\n<a href=\"http://en.wikipedia.org/wiki/Wav\">http://en.wikipedia.org/wiki/Wav</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
        return;
    }

    for(BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it) {
        if( (*it).enc.formats.findIndex(sFormatString) != -1 ) {
            KMessageBox::information( this,
            tools.stringToHTML(i18n(tools.getFormatInfoString((*it).info.format_descriptions,sFormatString))),
            i18n("File format")+": "+sFormatString,
            QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
            break;
        }
    }

/*    if( sFormatString == "ogg" ) { // http://www.vorbis.com/faq/ (en), http://www.mp3-heaven.net/Infos/Ogg:Vorbis/FAQ (de)
        KMessageBox::information( this,
        i18n("<p>Ogg Vorbis is a free alternative to MP3.</p>\n<p>In most cases it produces a file of better quality than MP3, you should use it, if you can.</p>\n<a href=\"http://en.wikipedia.org/wiki/Vorbis\">http://en.wikipedia.org/wiki/Vorbis</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else if( sFormatString == "mp3" ) { // http://www.mp3-heaven.net/Infos/MP3/FAQ (de)
        KMessageBox::information( this,
        i18n("<p>MP3 is the most popular file format.</p>\n<p>If you don't know what to choose, this should work with every audio player.</p>\n<a href=\"http://en.wikipedia.org/wiki/Mp3\">http://en.wikipedia.org/wiki/Mp3</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else if( sFormatString == "mpc" ) {
        KMessageBox::information( this,
        i18n("<p>Musepack is an MPEG 1 file format.</p>\n<p>It is designed for high bitrates but supportes low bitrates, too. Musepack is Open Source.</p>\n<a href=\"http://en.wikipedia.org/wiki/Musepack\">http://en.wikipedia.org/wiki/Musepack</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else if( sFormatString == "flac" ) { // http://flac.sourceforge.net/features.html (en)
        KMessageBox::information( this,
        i18n("<p>FLAC (Free Lossless Audio Compressor) is a free file format that losslessly compresses the audio data.</p>\n<p>The result is a very high quality but very big file.</p>\n<a href=\"http://en.wikipedia.org/wiki/Flac\">http://en.wikipedia.org/wiki/Flac</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else if( sFormatString == "ape" ) {
        KMessageBox::information( this,
        i18n("<p>Ape (Monkey's Audio) is a file format that losslessly compresses the audio data.</p>\n<p>The result is a very high quality but very big file. In most cases it is smaller than flac. Ape is freeware.</p>\n<a href=\"http://en.wikipedia.org/wiki/Monkey's_Audio\">http://en.wikipedia.org/wiki/Monkey's_Audio</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else if( sFormatString == "wav" ) {
        KMessageBox::information( this,
        i18n("<p>Wave is a file format, that doesn't compress it's audio data.</p>\n<p>So the quality is very high, but the file size is enormous. It is widely spread and should work with every audio player.</p>\n<a href=\"http://en.wikipedia.org/wiki/Wav\">http://en.wikipedia.org/wiki/Wav</a>"),
        i18n("File format")+": "+sFormatString,
        QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
    }
    else {
        KMessageBox::error( this,
        i18n("This file format (%s) doesn't exist.", sFormatString),
        i18n("Error") );
    }*/
}

// Edit this to insert new codecs
void OptionsSimple::profileChanged() // FIXME Edit this to insert new codecs
{
    QString last;

    if( cProfile->currentText() == i18n("Very Low") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLossyFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(cFormat->currentText()).encoder);
        if(plugin.enc.quality.enabled) {
            emit setQualityMode( "Quality" );
            emit setQuality( 20 );
        }
        else if(plugin.enc.bitrate.abr.enabled||plugin.enc.bitrate.cbr.enabled) {
            emit setQualityMode( "Bitrate" );
            emit setQuality( 64 );
        }
        emit setBitrateRange( false );
        emit setResample( true );
        emit setSampleRate( 22050 );
        emit setChannels( true );
        emit setNumChannels( "Mono" );
    }
    else if( cProfile->currentText() == i18n("Low") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLossyFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(cFormat->currentText()).encoder);
        if(plugin.enc.quality.enabled) {
            emit setQualityMode( "Quality" );
            emit setQuality( 30 );
        }
        else if(plugin.enc.bitrate.abr.enabled||plugin.enc.bitrate.cbr.enabled) {
            emit setQualityMode( "Bitrate" );
            emit setQuality( 96 );
        }
        emit setBitrateRange( false );
        emit setResample( true );
        emit setSampleRate( 22050 );
        emit setChannels( false );
    }
    else if( cProfile->currentText() == i18n("Medium") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLossyFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(cFormat->currentText()).encoder);
        if(plugin.enc.quality.enabled) {
            emit setQualityMode( "Quality" );
            emit setQuality( 40 );
        }
        else if(plugin.enc.bitrate.abr.enabled||plugin.enc.bitrate.cbr.enabled) {
            emit setQualityMode( "Bitrate" );
            emit setQuality( 192 );
        }
        emit setBitrateRange( false );
        emit setResample( false );
        emit setChannels( false );
    }
    else if( cProfile->currentText() == i18n("High") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLossyFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(cFormat->currentText()).encoder);
        if(plugin.enc.quality.enabled) {
            emit setQualityMode( "Quality" );
            emit setQuality( 50 );
        }
        else if(plugin.enc.bitrate.abr.enabled||plugin.enc.bitrate.cbr.enabled) {
            emit setQualityMode( "Bitrate" );
            emit setQuality( 240 );
        }
        emit setBitrateRange( false );
        emit setResample( false );
        emit setChannels( false );
    }
    else if( cProfile->currentText() == i18n("Very High") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLossyFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(cFormat->currentText()).encoder);
        if(plugin.enc.quality.enabled) {
            emit setQualityMode( "Quality" );
            emit setQuality( 60 );
        }
        else if(plugin.enc.bitrate.abr.enabled||plugin.enc.bitrate.cbr.enabled) {
            emit setQualityMode( "Bitrate" );
            emit setQuality( 320 );
        }
        emit setBitrateRange( false );
        emit setResample( false );
        emit setChannels( false );
    }
    else if( cProfile->currentText() == i18n("Lossless") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allLosslessFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->insertItem( "wav" );
        sFormat.append( "wav" );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
    }
    else if( cProfile->currentText() == i18n("User defined") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat=backendPlugins.allFileFormats();
        cFormat->insertStringList(sFormat);
        cFormat->insertItem( "wav" );
        sFormat.append( "wav" );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
    }
}

void OptionsSimple::formatChanged()
{
    emit setFormat( cFormat->currentText() );
}

