

#include "options.h"
#include "options_simple.h"
#include "options_detailed.h"
//#include "debug_tab.h"
//#include "more_options.h"
#include "config.h"
#include "tools.h"
#include "backend_plugins.h"

#include <qlayout.h>
#include <qtabwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qfileinfo.h>

#include <klocale.h>

#include <fileref.h>
#include <tag.h>
#include <tstring.h>


Options::Options( QWidget *parent, const char *name, int text )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this, 1, 1 );

    tab = new QTabWidget( this, "tab" );

    optionsS = new OptionsSimple( this, "optionsS", text );
    tab->addTab( optionsS, i18n("Simple") );

    optionsD = new OptionsDetailed( this, "optionsD" );
    tab->addTab( optionsD, i18n("Detailed") );

    /*debugTab = new DebugTab( this, "debugTab" );
    tab->addTab( debugTab, "Debug" );
    */

    tab->setCurrentPage(prefs.startTab);
    grid->addWidget( tab, 0, 0 );

    /*moreOptions = new MoreOptions(this);

    connect( optionsD, SIGNAL(showMoreOptions()),
             this, SLOT(showMoreOptions()) );
    */

    connect(optionsS,SIGNAL(setFormat(QString)),optionsD,SLOT(setFormat(QString)));
    connect(optionsS,SIGNAL(setQualityMode(QString)),optionsD,SLOT(setQualityMode(QString)));
    connect(optionsS,SIGNAL(setQuality(int)),optionsD,SLOT(setQuality(int)));
    connect(optionsS,SIGNAL(setBitrateRange(bool)),optionsD,SLOT(setBitrateRange(bool)));
    connect(optionsS,SIGNAL(setResample(bool)),optionsD,SLOT(setResample(bool)));
    connect(optionsS,SIGNAL(setSampleRate(int)),optionsD,SLOT(setSampleRate(int)));
    connect(optionsS,SIGNAL(setChannels(bool)),optionsD,SLOT(setChannels(bool)));
    connect(optionsS,SIGNAL(setNumChannels(QString)),optionsD,SLOT(setNumChannels(QString)));

    connect(tab,SIGNAL(currentChanged(QWidget*)),this,SLOT(tabChanged(QWidget*)));

    optionsS->profileChanged();
}

Options::~Options()
{
}

// Edit this to insert new codecs (optional)
void Options::addFiles( QStringList list )
{
    char cQuality[8], cBitrateRange[32];
    QString sFormat, sQuality, sBitrateMode, sBitrateRange, sSampleRate, sChannels, sReplayGain, sState;
    QStringList options;
    QString params;

    sFormat = optionsD->cFormat->currentText();
    sBitrateMode = optionsD->cBitrateMode->currentText();

    if( optionsD->cQualityMode->currentText() == i18n("Bitrate") ) {
        sprintf( cQuality, "%d kbps", optionsD->sQuality->value() );
        sQuality = cQuality;
    }
    else if( optionsD->cQualityMode->currentText() == i18n("Quality") ) {
        sprintf( cQuality, "%d", optionsD->sQuality->value() );
        sQuality = cQuality;
    }
    else {
        sQuality = "-";
        sBitrateMode = "-";
    }

    if( optionsD->cBitrateRange->isChecked() && optionsD->cBitrateRange->isEnabled() ) {
        sprintf(cBitrateRange, "%i-%i", optionsD->sMinBitrate->value(), optionsD->sMaxBitrate->value() );
        sBitrateRange = cBitrateRange;
    }
    else {
        sBitrateRange = "-";
    }

    if( optionsD->cResample->isChecked() && optionsD->cResample->isEnabled() ) {
        sSampleRate = optionsD->cSampleRate->currentText()+" Hz";
    }
    else {
        sSampleRate = "-";
    }

    if( optionsD->cChannels->isChecked() && optionsD->cChannels->isEnabled() ) {
        sChannels = optionsD->cNumChannels->currentText();
    }
    else {
        sChannels = "-";
    }

    if( optionsD->cReplayGain->isChecked() && optionsD->cReplayGain->isEnabled() ) {
        sReplayGain = i18n("yes");
    }
    else {
        sReplayGain = i18n("no");
    }

    /*if( sFormat == "wav" || sFormat == "flac" || sFormat == "ape" ) {
        sQuality = "-";
        sBitrateMode = "-";
        sBitrateRange = "-";
        sSampleRate = "-";
        sChannels = "-";
    }
    else if( sFormat == "mpc" ) {
        sBitrateRange = "-";
        sSampleRate = "-";
        sChannels = "-";
    }*/
    sState = i18n("Waiting...");

    QStringList::Iterator it = list.begin();
    while( it != list.end() )
    {
        if (*it == NULL)
            break;
        QFileInfo file(*it);
        if (!file.exists())
            break;
        if (file.isDir())
            break;

        QString sInputFormat=tools.fileExtension(*it);

        if( sInputFormat != "wav" || sFormat != "wav" )
        {
            if( sInputFormat != "wav" ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sInputFormat).decTime );
            }
            if( sFormat != "wav" ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sFormat).encTime );
            }
            if( sReplayGain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sFormat).repTime );
            }

            params=*it;
            params+="$soundkonverter-spacer$"+sFormat;
            params+="$soundkonverter-spacer$"+sQuality;
            params+="$soundkonverter-spacer$"+sBitrateRange;
            params+="$soundkonverter-spacer$"+sBitrateMode;
            params+="$soundkonverter-spacer$"+sSampleRate;
            params+="$soundkonverter-spacer$"+sChannels;
            params+="$soundkonverter-spacer$"+sReplayGain;
            params+="$soundkonverter-spacer$"+sState;

            options.clear();
            options.append(params);
            options.append(*it);
            options.append(sFormat);
            options.append(sQuality);
            options.append(sBitrateRange);
            options.append(sBitrateMode);
            options.append(sSampleRate);
            options.append(sChannels);
            options.append(sReplayGain);
            options.append(sState);
            emit addFile(options);
        }
        it++;
    }
    emit allFilesAdded();
}

// Edit this to insert new codecs
void Options::tabChanged( QWidget *widget ) // FIXME Edit this to insert new codecs
{
    QString format, qualityMode, numChannels;
    int quality, sampleRate;
    bool bitrateRange, resample, channels;

    if( widget == optionsS ) {
        format=optionsD->getFormat();
        qualityMode=optionsD->getQualityMode();
        numChannels=optionsD->getNumChannels();
        quality=optionsD->getQuality();
        sampleRate=optionsD->getSampleRate();
        bitrateRange=optionsD->getBitrateRange();
        resample=optionsD->getResample();
        channels=optionsD->getChannels();

        /*if( format == "flac" || format == "wav" || format == "ape" )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Lossless") );
        else if( format == "mpc" && quality == 20 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( format == "mpc" && quality == 30 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( format == "mpc" && quality == 40 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( format == "mpc" && quality == 50 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( format == "mpc" && quality == 60 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else if( qualityMode == i18n("Quality") && quality == 20 && !bitrateRange &&
        resample && sampleRate == 22050 && channels && numChannels == i18n("Mono") )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( qualityMode == i18n("Quality") && quality == 30 && !bitrateRange &&
        resample && sampleRate == 22050 && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( qualityMode == i18n("Quality") && quality == 40 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( qualityMode == i18n("Quality") && quality == 50 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( qualityMode == i18n("Quality") && quality == 60 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("User defined") );*/

/*        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).encoder);

        if( ( plugin.enc.quality.enabled && qualityMode == i18n("Quality") ) || ( ( plugin.enc.bitrate.abr || plugin.enc.bitrate.cbr ) && qualityMode == i18n("Bitrate") ) &&
        ( ( plugin.enc.quality.enabled && quality == 20 ) || ( plugin.enc.bitrate.abr || plugin.enc.bitrate.cbr ) && quality == 64 ) &&
        !bitrateRange &&
        resample
        && sampleRate == 22050 &&
        channels
        && numChannels == i18n("Mono") )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( qualityMode == i18n("Quality") && quality == 30 && !bitrateRange &&
        resample && sampleRate == 22050 && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( qualityMode == i18n("Quality") && quality == 40 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( qualityMode == i18n("Quality") && quality == 50 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( qualityMode == i18n("Quality") && quality == 60 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("User defined") );
*/

        optionsS->cProfile->setCurrentItem( optionsS->profileIndex("User defined") );

        // FIXME dirty
        optionsS->cFormat->clear();
        optionsS->sFormat=backendPlugins.allFileFormats();
        optionsS->cFormat->insertStringList(optionsS->sFormat);
        optionsS->cFormat->insertItem( "wav" );
        optionsS->sFormat.append( "wav" );
        optionsS->cFormat->setCurrentItem( optionsS->formatIndex(format) );

        optionsS->profileChanged();
    }
}

void Options::reset()
{
     QString format=optionsD->getFormat();

     optionsS->cFormat->clear();
     optionsS->sFormat=backendPlugins.allFileFormats();
     optionsS->cFormat->insertStringList(optionsS->sFormat);
     optionsS->cFormat->insertItem( "wav" );
     optionsS->sFormat.append( "wav" );
     optionsS->cFormat->setCurrentItem( optionsS->formatIndex(format) );
     optionsS->profileChanged();

     optionsD->cFormat->clear();
     optionsD->sFormat=backendPlugins.allFileFormats();
     optionsD->cFormat->insertStringList(optionsD->sFormat);
     optionsD->cFormat->insertItem( "wav" );
     optionsD->sFormat.append( "wav" );
     optionsD->cFormat->setCurrentItem( optionsD->formatIndex(format) );
     optionsD->formatChanged();
}

QString Options::currentFormat()
{
    return optionsD->cFormat->currentText();
}

/*void Options::showMoreOptions()
{
    moreOptions->exec();
}
*/
