

#include "more_options.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

#include <klocale.h>


MoreOptions::MoreOptions( QWidget *parent, const char *name, bool modal, WFlags f )
    : QDialog( parent, name, modal, f )
{
    setCaption( QString(i18n("More options")).append(" - soundKonverter") );

    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    QVBoxLayout *topBox = new QVBoxLayout();
    grid->addLayout( topBox, 0, 0 );

    QGroupBox *mp3Group = new QGroupBox( 3, Qt::Vertical, "mp3", this, "mp3Group" );
    topBox->addWidget(mp3Group);

    cCopyright = new QCheckBox( i18n("Copyright"), mp3Group, "cCopyright" );
    cCopy = new QCheckBox( i18n("Copy"), mp3Group, "cCopy" );
    cCRC = new QCheckBox( i18n("CRC error protection"), mp3Group, "cCRC" );

    QHBoxLayout *buttonBox = new QHBoxLayout();
    grid->addLayout( buttonBox, 1, 0 );

    buttonBox->addStretch();

    pOk = new QPushButton( i18n("Close"), this, "pOk" );
    buttonBox->addWidget(pOk);

    connect( pOk, SIGNAL(clicked()),
             this, SLOT(accept()) );
}

MoreOptions::~MoreOptions()
{
}
