
#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qfont.h>


class FileFormat
{
public:
    QString extension;
    QString encoder;
    QString decoder;
    QString replaygain;
    QStringList encoders;
    QStringList decoders;
    QStringList replaygains;
    float encTime;
    float decTime;
    float repTime;
    float compressionLevel;

    FileFormat();
    FileFormat(QString ext);
    ~FileFormat();
};

struct ConvertInfo
{
    int pauseMS;
    bool mp3CrcCheck;
    bool mp3ISO;
};

struct Backends
{
    QStringList directories;
    QStringList programs;
};

struct Check
{
    bool online_plugins;
    bool backends;
    bool online_backends;
};

typedef QValueList<FileFormat> FileFormatList;

/**
 * @short Config
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class Config
{
public:
    FileFormatList fileFormatList;
    ConvertInfo convert;
    Backends backend;
    Check check;
    bool firstRun;
    int startTab;
    QFont fileListFont;
    bool askForNewOptions;
    QString calibrationFile;
    bool showToolBar;

    void read();
    void write();
    void readOldConfig();
    FileFormat fileFormat(QString ext);
    void rebuildFormatList();

private:
    void createFormat(QString,QString,QString);

};

extern Config prefs;

#endif // _CONFIG_H_
