/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PLAYLIST_H_
#define _PLAYLIST_H_

#include "playlistbase.h"
#include <qvaluelist.h>
#include <qstringlist.h>

class PlaylistItem {

public:
	PlaylistItem() { _filename=""; _name=""; _duration=0; 
                     _played = FALSE; _deleted=FALSE; };
	PlaylistItem(QString filename, QString name, double duration) {
		         _filename = filename; _name = name; _duration = duration; 
                 _played = FALSE; _deleted = FALSE; };
	~PlaylistItem() {};

	void setFilename(QString filename) { _filename = filename; };
	void setName(QString name) { _name = name; };
	void setDuration(double duration) { _duration = duration; };
	void setPlayed(bool b) { _played = b; };
	void setMarkForDeletion(bool b) { _deleted = b; };

	QString filename() { return _filename; };
	QString name() { return _name; };
	double duration() { return _duration; };
	bool played() { return _played; };
	bool markedForDeletion() { return _deleted; };

private:
	QString _filename, _name;
	double _duration;
	bool _played, _deleted;
};


class Core;
class QPopupMenu;
class QSettings;

class Playlist : public PlaylistBase
{
	Q_OBJECT

public:
	Playlist( Core *c, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~Playlist();

public slots:
	void clear();
	void list();

	void addItem(QString filename, QString name, double duration);

	// Start playing, from item 0 if shuffle is off, or from
	// a random item otherwise
	void startPlay();

	void playItem(int n);

	virtual void playNext();
	virtual void playPrev();

	virtual void removeSelected();
	virtual void removeAll();

	virtual void addCurrentFile();
	virtual void addFiles();
	virtual void addDirectory();

	virtual void addFiles(QStringList files);
	virtual void addDirectory(QString dir);

    virtual void load();
    virtual void save();

	virtual void load_m3u(QString file);
	virtual void save_m3u(QString file);

	virtual void getMediaInfo();

	virtual void saveSettings();
	virtual void loadSettings();

signals:
	void playlistEnded();
	void visibilityChanged();

protected:
	void updateView();
	void setCurrentItem(int current);
	void clearPlayedTag();
	int chooseRandomItem();
	void swapItems(int item1, int item2 );
	QString lastDir();

	virtual void dragEnterEvent( QDragEnterEvent * ) ;
	virtual void dropEvent ( QDropEvent * );
	virtual void hideEvent ( QHideEvent * );
	virtual void showEvent ( QShowEvent * );
	virtual void closeEvent( QCloseEvent * e );

protected slots:
	virtual void languageChange();

	virtual void playCurrent();
	virtual void itemDoubleClicked(int row);
	virtual void showPopup(int row, int col, const QPoint & pos);
	virtual void upItem();
	virtual void downItem();
	virtual void editCurrentItem();
	virtual void editItem(int item);

protected:
	typedef QValueList <PlaylistItem> PlaylistItemList;
	PlaylistItemList pl;
	int current_item;

	QString playlist_path;
	QString latest_dir;

	Core * core;
	QPopupMenu * add_menu;
	QPopupMenu * remove_menu;
	QPopupMenu * popup;
};

#endif

