/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef MPLAYERWINDOW_H
#define MPLAYERWINDOW_H

#include <qwidget.h>
#include <qsize.h>
#include <qpoint.h>
#include "config.h"

class QWidget;
class QLabel;
class QKeyEvent;

#if USE_GL_WIDGET
#include <qgl.h>
#define SC_WIDGET QGLWidget
#else
#define SC_WIDGET QWidget
#endif

/* This class hides the mouse cursor after some seconds, if not moved */

class Screen : public SC_WIDGET
{
	Q_OBJECT

public:
	Screen(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	~Screen();

signals:
	void mouseMoved(QPoint);

protected:
	virtual void mouseMoveEvent( QMouseEvent * e );
	virtual void paintEvent ( QPaintEvent * e );

protected slots:
	virtual void checkMousePos();

private:
	QPoint cursor_pos, last_cursor_pos;
};

/* This class ca be set to not delete the background */

class MplayerLayer : public Screen
{
	Q_OBJECT

public:
	MplayerLayer(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	~MplayerLayer();

	void allowClearingBackground(bool b);
	bool isClearingBackgroundAllowed() { return allow_clearing; };

protected:
	virtual void paintEvent ( QPaintEvent * e );

private:
	bool allow_clearing;
};


class MplayerWindow : public Screen
{
    Q_OBJECT

public:
    MplayerWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
    ~MplayerWindow();
    
	void showLogo( bool b);
	MplayerLayer * mplayerLayer();
	void setResolution( int w, int h);
	void setAspect( double asp);
	void setMonitorAspect(double asp);
	void updateVideoWindow();

	void setColorKey(QColor c);

	void allowClearingBackground(bool b);
	bool isClearingBackgroundAllowed();

	void setOffsetX( int );
	int offsetX();

	void setOffsetY( int );
	int offsetY();

	void setZoom( double );
	double zoom();

	virtual QSize sizeHint () const;
	virtual QSize minimumSizeHint() const;

public slots:
	void moveLeft();
	void moveRight();
	void moveUp();
	void moveDown();
	void incZoom();
	void decZoom();

protected:
    virtual void resizeEvent( QResizeEvent * e);
    virtual void mouseReleaseEvent( QMouseEvent * e);
	virtual void mouseDoubleClickEvent( QMouseEvent * e );
	virtual void wheelEvent( QWheelEvent * e );
	void moveLayer( int offset_x, int offset_y );

protected slots:
	virtual void languageChange();
	virtual void translatePos(QPoint p );

signals:
    void rightButtonReleased( QPoint p );
	void doubleClicked();
	void leftClicked();
	void keyPressed(QKeyEvent * e);
	void wheelUp();
	void wheelDown();

protected:
    int video_width, video_height;
    double aspect;
	double monitoraspect;

	MplayerLayer * mplayerlayer;
	QLabel * logo;

	// Zoom and moving
	int offset_x, offset_y;
	double zoom_factor;

	// Original pos and dimensions of the mplayerlayer
	// before zooming or moving
	int orig_x, orig_y;
	int orig_width, orig_height;
};


#endif

