/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _CSMANAGER_H_
#define _CSMANAGER_H_

// Client-Server manager

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

class MyServer;
class MyClient;


class CSManager : public QObject
{
	Q_OBJECT

public:

	enum StartingCode { ServerStarted = 0, UnknownServerFound = 1,
                        ServerDoesNotRespond = 2 };

	CSManager( int port, QStringList files_to_open,
               QObject * parent = 0, const char * name = 0 );
	~CSManager();

	void setActionsList(QStringList l) { actions_list = l; };
	QStringList actionsList() { return actions_list; };

signals:
	void requestOpen(QString);
	void requestOpenFiles(QStringList);
	void requestFunction(QString);

	// The GUI should continue start up (show, and open initial file)
	void mayStartUp(int);

	// Another instance is running, GUI should close
	void mayClose();

protected slots:
	// Called when we've connected to port.
	void connectedToPort();

	// Called if it's not possible to port.
	void notConnectedToPort();

	// Called when we've connected to another running instance of smplayer.
	void connectedToInstance();

	// Connection closed
	void connectionToInstanceClosed();

	// Connected to server, but it's not smplayer
	void connectedToUnknownServer();

	void serverDontRespond();

protected:
	MyServer * server;
	MyClient * client;
	int _port;
	QStringList _files_to_open;

private:
	QStringList actions_list;
};

#endif
