#include "petsc.h"
#include "petscfix.h"
/* opts.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetfromoptions_ EPSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetfromoptions_ epssetfromoptions
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgettolerances_ EPSGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgettolerances_ epsgettolerances
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssettolerances_ EPSSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssettolerances_ epssettolerances
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetdimensions_ EPSGETDIMENSIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetdimensions_ epsgetdimensions
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetdimensions_ EPSSETDIMENSIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetdimensions_ epssetdimensions
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetwhicheigenpairs_ EPSSETWHICHEIGENPAIRS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetwhicheigenpairs_ epssetwhicheigenpairs
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetproblemtype_ EPSSETPROBLEMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetproblemtype_ epssetproblemtype
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetclass_ EPSSETCLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetclass_ epssetclass
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetorthogonalization_ EPSSETORTHOGONALIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetorthogonalization_ epssetorthogonalization
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epssetfromoptions_(EPS *eps, int *__ierr ){
*__ierr = EPSSetFromOptions(*eps);
}
void PETSC_STDCALL  epsgettolerances_(EPS *eps,PetscReal *tol,int *maxits, int *__ierr ){
*__ierr = EPSGetTolerances(*eps,tol,maxits);
}
void PETSC_STDCALL  epssettolerances_(EPS *eps,PetscReal *tol,int *maxits, int *__ierr ){
*__ierr = EPSSetTolerances(*eps,*tol,*maxits);
}
void PETSC_STDCALL  epsgetdimensions_(EPS *eps,int *nev,int *ncv, int *__ierr ){
*__ierr = EPSGetDimensions(*eps,nev,ncv);
}
void PETSC_STDCALL  epssetdimensions_(EPS *eps,int *nev,int *ncv, int *__ierr ){
*__ierr = EPSSetDimensions(*eps,*nev,*ncv);
}
void PETSC_STDCALL  epssetwhicheigenpairs_(EPS *eps,EPSWhich *which, int *__ierr ){
*__ierr = EPSSetWhichEigenpairs(*eps,*which);
}
void PETSC_STDCALL  epssetproblemtype_(EPS *eps,EPSProblemType *type, int *__ierr ){
*__ierr = EPSSetProblemType(*eps,*type);
}
void PETSC_STDCALL  epssetclass_(EPS *eps,EPSClass *cl, int *__ierr ){
*__ierr = EPSSetClass(*eps,*cl);
}
void PETSC_STDCALL  epssetorthogonalization_(EPS *eps,EPSOrthogonalizationType *type,EPSOrthogonalizationRefinementType *refinement,PetscReal *eta, int *__ierr ){
*__ierr = EPSSetOrthogonalization(*eps,*type,*refinement,*eta);
}
#if defined(__cplusplus)
}
#endif
