/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-decoder.h Dvd object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DECODER_DTS_H__
#define __DVD_DECODER_DTS_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DECODER_DTS_TYPE		(dvd_decoder_dts_get_type())
#define DVD_DECODER_DTS(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DECODER_DTS_TYPE, DvdDecoderDts))
#define DVD_DECODER_DTS_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DECODER_DTS_TYPE, DvdDecoderDtsClass))
#define DVD_IS_DVD_DECODER_DTS(o)	(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DECODER_DTS_TYPE))
#define DVD_IS_DVD_DECODER_DTS_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DECODER_DTS_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdDecoderDts		DvdDecoderDts;
typedef struct	_DvdDecoderDtsClass	DvdDecoderDtsClass;
typedef struct	_DvdDtsSyncHeader	DvdDtsSyncHeader;
typedef struct	_DvdDtsBSHeader		DvdDtsBSHeader;

/* DTS stream synchronization header */
struct _DvdDtsSyncHeader {
	guint32	sync_word;
};

/* DTS Bit Stream Header = 9 bytes or 11 with crc present */
struct _DvdDtsBSHeader {
	guint	frame_type		: 1;
	guint	deficit_sample_count	: 5;
	guint	crc_present		: 1;
	guint	pcm_sample_blocks	: 7;
	guint	frame_size		: 14;
	guint	audio_mode		: 6;
	guint	sample_fequency		: 4;
	guint	bit_rate		: 5;
	guint	down_mix_enabled	: 1;
	guint	dynamic_range_flag	: 1;
	guint	time_stamp_flag		: 1;
	guint	aux_data_flag		: 1;
	guint	hdcd			: 1;
	/* start byte 7 */
	guint	ext_audio_desc_flag	: 3;
	guint	ext_coding_flag		: 1;
	guint	syncword_insertion_flag	: 1;
	guint	lfe_flag		: 2;
	guint	hflag			: 1;
	/* start byte 8 */
	/* 2 byte crc check for frame header up to this point only if crc_present = 1 */
	/* 2 more bytes */
	guint	multirate_interpolator	: 1;
	guint	software_revision	: 4;
	guint	copy_history		: 2;
	guint	source_pcm_resolution	: 3;
	guint	front_sum_difference	: 1;
	guint	surr_sum_difference	: 1;
	guint	dialog_normalisation	: 4;
};

struct _DvdDecoderDts {
	DvdDecoder	 parent;
	
	DvdDtsSyncHeader sync_hdr;
	DvdDtsBSHeader	 bs_hdr;
	guint8		 syncframe_byte;
	guint16		 bytes_skipped;
	guint32		 clocks_per_frame;
	guint16		 bytes_per_frame;
};


struct _DvdDecoderDtsClass {
	DvdDecoderClass	parent;
};

/* --- prototypes --- */
GType		dvd_decoder_dts_get_type		(void);

G_END_DECLS

#endif /*__DVD_DECODER_DTS_H__*/
