/*
 * Seti@Home properties dialog box
 * (C) 2002 Jean-Michel Ardantz
 *
 * Author: Richard Kinder <r_kinder@yahoo.com>
 * Author: Jean-Michel Ardantz <jmardantz@ifrance.com>
 *
 * Changelog:
 * $Log: seti_properties.c,v $
 * Revision 1.1.2.8  2003/03/06 00:53:29  r_kinder
 * Implement current CPU time feature.
 *
 * Revision 1.1.2.7  2003/03/05 05:57:55  r_kinder
 * GUI fixes, bug fixes.
 *
 * Revision 1.1.2.6  2003/03/05 02:51:09  r_kinder
 * Border applet option implemented (feature request 690359)
 *
 * Revision 1.1.2.5  2003/03/04 09:09:58  r_kinder
 * Add extra parameter to draw a border around the applet.
 *
 * Revision 1.1.2.4  2003/01/30 22:32:15  r_kinder
 * Fixes for vertically aligned panels - shrink it to be only a radar.
 *
 * Revision 1.1.2.3  2003/01/23 23:37:28  r_kinder
 * Do a 'make indent' on the files. Remove legacy code that is no longer
 * pertinant.
 *
 * Revision 1.1.2.2  2003/01/14 00:30:45  r_kinder
 * Various fixes.
 *
 * Revision 1.1.2.1  2002/11/05 21:31:30  jmardantz
 * Gnome 2 port
 *
 *
 */

#include "config.h"
#include "seti_applet.h"

#include <gtk/gtk.h>
#include <libgnomeui/libgnomeui.h>
#include <glade/glade.h>

// Defines
#define GLADE_FILE   GLADEDIR "/seti-applet.glade.glade"

// Prototypes of statics
static void on_SetiAppletProperties_apply(GnomeDialog *,
                                          gint,
                                          gpointer);
static void on_SetiAppletProperties_help(GnomePropertyBox *,
                                         gint,
                                         gpointer);
static void on_Adv_Check_SetiExe_toggled(GtkToggleButton *,
                                         gpointer);
static void on_AppletSize_Check_AutoResize_toggled(GtkToggleButton *,
                                                   gpointer);
static void on_AppletSize_Check_LockXY_toggled(GtkToggleButton *,
                                               gpointer);
static void on_AppletSize_Entry_Presets_changed(GtkEntry *,
                                                gpointer);


static void
on_AppletSize_Check_draw_border_toggled(GtkToggleButton *togglebutton,
                                        gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;
    sa->applet_gui->custom_size->draw_border = gtk_toggle_button_get_active(togglebutton);
    check_change_applet(sa->applet_gui->applet,sa);
}

static void
on_Adv_Check_xseti_toggled(GtkToggleButton *togglebutton,
                                        gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;
    sa->launch_xseti = gtk_toggle_button_get_active(togglebutton);
}

static void
on_Adv_Check_SetiExe_toggled(GtkToggleButton * togglebutton,
                             gpointer user_data)
{
    //Let the extra seti dir setting take input based on the value of the
    //toggle button.
    gtk_entry_set_editable(GTK_ENTRY(user_data),
                           gtk_toggle_button_get_active(togglebutton));
    gtk_widget_set_sensitive(user_data,
                             gtk_toggle_button_get_active(togglebutton));
}


static void
toggle_widget(GtkWidget * w,
              gpointer sens)
{
    gboolean    sensitive = *(gboolean *) sens;
    gtk_widget_set_sensitive(w, sensitive);
}


static void
on_AppletSize_Check_AutoResize_toggled(GtkToggleButton * togglebutton,
                                       gpointer user_data)
{
    gboolean    toggle = !gtk_toggle_button_get_active(togglebutton);

    // Make sensitive/unsensitive all widgets of the container 
    gtk_container_foreach(GTK_CONTAINER(user_data), toggle_widget, &toggle);

    // Always make sentitive the check box 
    gtk_widget_set_sensitive(GTK_WIDGET(togglebutton), TRUE);
}

static void
on_AppletSize_Check_AutoResize_toggled2(GtkToggleButton *togglebutton,
                                        gpointer user_data)
{
    setiapplet *sa = (setiapplet *)user_data;
    check_change_applet(sa->applet_gui->applet,sa);
}


static void
on_AppletSize_Check_LockXY_toggled(GtkToggleButton * togglebutton,
                                   gpointer user_data)
{
}


static void
on_AppletSize_Entry_Presets_changed(GtkEntry * entry_presets,
                                    gpointer user_data)
{
    gchar      *presets = NULL;
    gint        scale = 12;
    setiapplet *sa = (setiapplet *) user_data;

    presets = (gchar *) gtk_entry_get_text(entry_presets);
    if (strstr (presets, "12")) scale = 12;
    if (strstr (presets, "24")) scale = 24;
    if (strstr (presets, "36")) scale = 36;
    if (strstr (presets, "48")) scale = 48;
    if (strstr (presets, "64")) scale = 64;
    if (strstr (presets, "80")) scale = 80;
    if (strstr (presets, "128")) scale = 128;

    gtk_range_set_value(GTK_RANGE(sa->properties_gui->scale_x), scale);
    gtk_range_set_value(GTK_RANGE(sa->properties_gui->scale_y), scale);
}


static void
on_SetiAppletProperties_apply(GnomeDialog * gpb,
                              gint arg1,
                              gpointer data)
{
    setiapplet *sa = (setiapplet *) data;
    gchar      *new_text;
    gint        toggle_status;

    // final apply on close, prevent multiple calls of this method
    if(arg1 == -1)
    {
        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->
                                          percentage_check));
        sa->value_mask[PERCENT] |= (toggle_status ? VALUE_DISPLAY : VALUE_HIDE);
        sa->value_mask[PERCENT] &=
            (toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY);

        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->gaussian_check));
        sa->value_mask[GAUSSIAN] |= toggle_status ? VALUE_DISPLAY : VALUE_HIDE;
        sa->value_mask[GAUSSIAN] &=
            toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY;

        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->spike_check));
        sa->value_mask[SPIKE] |= toggle_status ? VALUE_DISPLAY : VALUE_HIDE;
        sa->value_mask[SPIKE] &= toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY;

        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->
                                          units_processed_check));
        sa->value_mask[UNITS] |= toggle_status ? VALUE_DISPLAY : VALUE_HIDE;
        sa->value_mask[UNITS] &= toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY;

        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->total_CPU_check));
        sa->value_mask[CPUTIME] |= toggle_status ? VALUE_DISPLAY : VALUE_HIDE;
        sa->value_mask[CPUTIME] &= toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY;

        toggle_status =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->
                                          current_CPU_check));
        sa->value_mask[CPUTIMECURRENT] |=
            (toggle_status ? VALUE_DISPLAY : VALUE_HIDE);
        sa->value_mask[CPUTIMECURRENT] &=
            (toggle_status ? ~VALUE_HIDE : ~VALUE_DISPLAY);

        new_text =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY
                               (sa->properties_gui->seti_location_text));
        if(sa->seti_dir != NULL)
        {
            g_free(sa->seti_dir);
        }
        sa->seti_dir = g_strdup(new_text);
        sa->update_interval =
            gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON
                                             (sa->properties_gui->
                                              ui_update_spin));
        sa->file_update_interval =
            gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON
                                             (sa->properties_gui->
                                              file_update_spin));
        sa->launch_on_start =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->launch_on_start));
        sa->nice_value =
            (gint) gtk_range_get_value(GTK_RANGE(sa->properties_gui->nice_val));

        // Get sextra parms 
        if(sa->extra_params != NULL)
        {
            g_free(sa->extra_params);
        }
        new_text =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->properties_gui->extra_parm_text));

        if(new_text)
        {
            if(*new_text == 0)
            {
                sa->extra_params = NULL;
            }
            else
            {
                sa->extra_params = g_strdup(new_text);
            }
        }
        else
        {
            sa->extra_params = NULL;
        }

        // Get separate exe dir
        sa->separate_exe_dir =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->
                                          use_diff_dir_exe));
        if(sa->separate_exe_dir)
        {
            if(sa->seti_exe_dir)
            {
                g_free(sa->seti_exe_dir);
            }
            new_text =
                (gchar *)
                gtk_entry_get_text(GTK_ENTRY
                                   (sa->properties_gui->seti_alternate_dir));
            sa->seti_exe_dir = g_strdup(new_text);
        }

        // Get widget look/size properties
        sa->applet_gui->custom_size->auto_size =
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->properties_gui->
                                          auto_resize_check));
        if(!sa->applet_gui->custom_size->auto_size)
        {
            // Update the custom size pieces if non-auto resize selected.
            sa->applet_gui->custom_size->x =
                (gint)
                gtk_range_get_value(GTK_RANGE(sa->properties_gui->scale_x));
            sa->applet_gui->custom_size->y =
                (gint)
                gtk_range_get_value(GTK_RANGE(sa->properties_gui->scale_y));
            sa->applet_gui->custom_size->lock_xy =
                gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                             (sa->properties_gui->
                                              lock_xy_check));
            sa->applet_gui->custom_size->only_radar =
                gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                             (sa->properties_gui->
                                              radar_only_check));
        }
        else
        {
            // Set default value for the custom size pieces
            sa->applet_gui->custom_size->x = 12;
            sa->applet_gui->custom_size->y = 12;
            sa->applet_gui->custom_size->lock_xy = FALSE;
            sa->applet_gui->custom_size->only_radar = FALSE;
        }

        // Save the preferences to gconf 
        panel_applet_preferences_save(sa, PANEL_APPLET(sa->applet_gui->applet));

        re_read_state_file(sa);
        re_read_user_file(sa);
        check_change_applet(PANEL_APPLET(sa->applet_gui->applet), sa);
        check_change_pixmap(sa);
        start_callback(sa);
    }
}


void
on_SetiAppletProperties_help(GnomePropertyBox * gnomepropertybox,
                             gint arg1,
                             gpointer user_data)
{
#ifdef FIXME
    help_cb(NULL, NULL);
#endif
}


/*
 * create_SetiAppletProperties
 * Create the properties dialog box
 *
 * Param: sa the setiapplet structure for the applet in use
 */
void
create_SetiAppletProperties(setiapplet * sa)
{
    GtkWidget  *SetiAppletProperties;
    GtkWidget  *Container;
    GtkWidget  *currentWidget;
    GladeXML   *gui = NULL;

    // Load the druid glade file
    gui = glade_xml_new(GLADE_FILE, "SetiAppletProperties", NULL);
    if(!gui)
        gui_warning("Error loading glade file");

    // Save some usefuls widgets
    SetiAppletProperties = glade_xml_get_widget(gui, "SetiAppletProperties");
    Container = glade_xml_get_widget(gui, "vbox15");
    sa->properties_gui->seti_location_text =
        glade_xml_get_widget(gui, "Basic_Entry_SetiExe");
    sa->properties_gui->units_processed_check =
        glade_xml_get_widget(gui, "Basic_Check_TotUnits");
    sa->properties_gui->total_CPU_check =
        glade_xml_get_widget(gui, "Basic_Check_TotCPU");
    sa->properties_gui->current_CPU_check =
        glade_xml_get_widget(gui, "Basic_Check_CPUTimeCurrent");
    sa->properties_gui->spike_check =
        glade_xml_get_widget(gui, "Basic_Check_BestSpike");
    sa->properties_gui->gaussian_check =
        glade_xml_get_widget(gui, "Basic_Check_BestGaus");
    sa->properties_gui->percentage_check =
        glade_xml_get_widget(gui, "Basic_Check_Percent");
    sa->properties_gui->ui_update_spin =
        glade_xml_get_widget(gui, "Adv_Spin_StatusUpdate");
    sa->properties_gui->file_update_spin =
        glade_xml_get_widget(gui, "Adv_Spin_StateReread");
    sa->properties_gui->launch_on_start =
        glade_xml_get_widget(gui, "Adv_Check_AutoLaunch");
    sa->properties_gui->nice_val =
        glade_xml_get_widget(gui, "Adv_HScale_NiceVal");
    sa->properties_gui->extra_parm_text =
        glade_xml_get_widget(gui, "Adv_Entry_ExtraCLI");
    sa->properties_gui->use_diff_dir_exe =
        glade_xml_get_widget(gui, "Adv_Check_SetiExe");
    sa->properties_gui->seti_alternate_dir =
        glade_xml_get_widget(gui, "Adv_Entry_SetiExeDir");
    sa->properties_gui->auto_resize_check =
        glade_xml_get_widget(gui, "AppletSize_Check_AutoResize");
    sa->properties_gui->scale_x =
        glade_xml_get_widget(gui, "AppletSize_ScaleX");
    sa->properties_gui->scale_y =
        glade_xml_get_widget(gui, "AppletSize_ScaleY");
    sa->properties_gui->lock_xy_check =
        glade_xml_get_widget(gui, "AppletSize_Check_LockXY");
    sa->properties_gui->radar_only_check =
        glade_xml_get_widget(gui, "AppletSize_Check_RadarOnly");
    sa->properties_gui->combo_presets =
        glade_xml_get_widget(gui, "AppletSize_Combo_Presets");
    sa->properties_gui->entry_presets =
        glade_xml_get_widget(gui, "AppletSize_ComboEntry_Presets");

    // Handlers to toggle the 'apply' button when widgets are clicked/changed
    g_signal_connect(G_OBJECT(SetiAppletProperties),
                     "apply", G_CALLBACK(on_SetiAppletProperties_apply), sa);

    // Handlers to toggle the use of a separate exe dir
    g_signal_connect(G_OBJECT(sa->properties_gui->use_diff_dir_exe),
                     "toggled",
                     G_CALLBACK(on_Adv_Check_SetiExe_toggled),
                     G_OBJECT(sa->properties_gui->seti_alternate_dir));

    g_signal_connect(G_OBJECT(glade_xml_get_widget(gui, "Adv_Check_xseti")), "toggled", G_CALLBACK(on_Adv_Check_xseti_toggled),sa);

    g_signal_connect(G_OBJECT(glade_xml_get_widget(gui, "AppletSize_Check_draw_border")), "toggled", G_CALLBACK(on_AppletSize_Check_draw_border_toggled),sa);

    // Handlers to toggle the Automaic resize check box
    g_signal_connect(G_OBJECT(sa->properties_gui->auto_resize_check),
                     "toggled",
                     G_CALLBACK(on_AppletSize_Check_AutoResize_toggled),
                     Container);
    g_signal_connect(G_OBJECT(sa->properties_gui->auto_resize_check),
                     "toggled",
                     G_CALLBACK(on_AppletSize_Check_AutoResize_toggled2),
                     sa);

    // Handlers to toggle the combo selection
    g_signal_connect(G_OBJECT(sa->properties_gui->entry_presets),
                     "changed",
                     G_CALLBACK(on_AppletSize_Entry_Presets_changed), sa);

    // Handlers to toggle the lock xy check box
    g_signal_connect(G_OBJECT(sa->properties_gui->lock_xy_check),
                     "toggled",
                     G_CALLBACK(on_AppletSize_Check_LockXY_toggled), NULL);

    {
        static gchar *check_widgets[6][16] =
            {
            {"toggled", "Basic_Check_BestSpike", "Basic_Check_BestGaus",
               "Basic_Check_TotCPU", "Basic_Check_TotUnits",
               "Basic_Check_Percent", "Basic_Check_CPUTimeCurrent",
               "Adv_Check_AutoLaunch", "Adv_Check_SetiExe",
               "AppletSize_Check_AutoResize",
               "AppletSize_Check_LockXY", "AppletSize_Check_RadarOnly", 
               "AppletSize_Check_draw_border", "Adv_Check_xseti", NULL},
            {"changed", "Basic_Entry_SetiExe", "Adv_Entry_ExtraCLI",
             "Adv_Entry_SetiExeDir", NULL},
            {"changed", "Adv_Spin_StatusUpdate", "Adv_Spin_StateReread", NULL},
            {"value_changed", "Adv_Spin_StatusUpdate", "Adv_Spin_StateReread",
             NULL},
            {"value_changed", "Adv_HScale_NiceVal", "AppletSize_ScaleX",
             "AppletSize_ScaleY", NULL},
             NULL
            };
        gboolean    default_toggles[] = { sa->value_mask[SPIKE] & VALUE_DISPLAY,
            0,
            sa->value_mask[CPUTIME] & VALUE_DISPLAY,
            sa->value_mask[UNITS] & VALUE_DISPLAY,
            sa->value_mask[PERCENT] & VALUE_DISPLAY,
            sa->value_mask[CPUTIMECURRENT] & VALUE_DISPLAY,
            sa->launch_on_start,
            sa->separate_exe_dir,
            sa->applet_gui->custom_size->auto_size,
            sa->applet_gui->custom_size->lock_xy,
            sa->applet_gui->custom_size->only_radar,
            sa->applet_gui->custom_size->draw_border,
            sa->launch_xseti
        };
        gchar      *default_entries[] = { sa->seti_dir,
            sa->extra_params,
            sa->seti_exe_dir
        };
        gint        default_spins[] = { sa->update_interval,
            sa->file_update_interval
        };
        gint        default_scales[] = { sa->nice_value,
            sa->applet_gui->custom_size->x,
            sa->applet_gui->custom_size->y,
        };
        int         i = 0;
        while(check_widgets[i][0] != NULL)
        {
            int         j = 1;
            gchar      *signal_name = check_widgets[i][0];
            while(check_widgets[i][j] != NULL)
            {
                currentWidget = glade_xml_get_widget(gui, check_widgets[i][j]);
                gtk_signal_connect_object(GTK_OBJECT(currentWidget),
                                          signal_name,
                                          GTK_SIGNAL_FUNC
                                          (gnome_property_box_changed),
                                          GTK_OBJECT(SetiAppletProperties));
                //g_message("Looking at widget %s\n", check_widgets[i][j]);
                switch (i)
                {
                    case 0:
                        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
                                                     (currentWidget),
                                                     default_toggles[j -
                                                                     1] ? 1 :
                                                     0);
                        g_message("Setting checkbox %s to %s\n",
                                  check_widgets[i][j],
                                  default_toggles[j - 1] ? "true" : "false");
                        break;
                    case 1:
                        gtk_entry_set_text(GTK_ENTRY(currentWidget),
                                           default_entries[j - 1]);
                        break;
                    case 2:
                        gtk_spin_button_set_value(GTK_SPIN_BUTTON
                                                  (currentWidget),
                                                  (gdouble) default_spins[j -
                                                                          1]);
                        break;
                    case 4:
                        gtk_range_set_value(GTK_RANGE(currentWidget),
                                            (gdouble) default_scales[j - 1]);
                        break;
                }
                j++;
            }
            i++;
        }
    }

    gtk_entry_set_editable(GTK_ENTRY(sa->properties_gui->seti_alternate_dir),
                           sa->separate_exe_dir);
    gtk_widget_set_sensitive(sa->properties_gui->seti_alternate_dir,
                             sa->separate_exe_dir);
}
