/*
 * SetiApplet.h
 *
 * Description: struct and prototype definitions for seti applet
 *
 * Author: Richard Kinder <r_kinder@yahoo.com>
 *
 * Date: 8/1/00
 *
 * Changelog:
 * $Log: seti_applet.h,v $
 * Revision 1.9.4.16  2003/03/06 00:53:29  r_kinder
 * Implement current CPU time feature.
 *
 * Revision 1.9.4.15  2003/03/05 05:57:55  r_kinder
 * GUI fixes, bug fixes.
 *
 * Revision 1.9.4.14  2003/03/05 02:51:08  r_kinder
 * Border applet option implemented (feature request 690359)
 *
 * Revision 1.9.4.13  2003/03/04 02:50:12  r_kinder
 * Fixups for RH 8.0 rpm build, creation of a new skin (nestor).
 *
 * Revision 1.9.4.12  2003/01/28 08:11:23  r_kinder
 * Minor bug fixes, change the default skin look so it looks good on small
 * panels (when fixed size with only the radar is selected).
 *
 * Revision 1.9.4.11  2003/01/23 23:37:28  r_kinder
 * Do a 'make indent' on the files. Remove legacy code that is no longer
 * pertinant.
 *
 * Revision 1.9.4.10  2002/11/29 07:08:32  r_kinder
 * Port to GNOME 2.x intermediate checkin.
 *
 * Revision 1.9.4.9  2002/11/05 21:31:30  jmardantz
 * Gnome 2 port
 *
 * Revision 1.9.4.8  2002/04/09 11:26:13  r_kinder
 * Fixes for crash on removal from panel, misc warning fixes.
 *
 * Revision 1.9.4.7  2002/04/07 23:44:36  r_kinder
 * Functionally almost complete version - still need to work on the graphics, but
 * the splitting of UI from the main code is almost complete (still debating
 * whether to put the properties interface in a new module). Works.
 *
 * Revision 1.9.4.6  2002/03/28 22:43:31  r_kinder
 * Intermediate checkin - will compile, build, run, but the graphics will be a
 * bit screwy.
 *
 * Revision 1.9.4.5  2002/03/25 11:10:55  r_kinder
 * Properties now save and restore correctly. Intermediate checkin.
 *
 * Revision 1.9.4.4  2002/03/07 11:39:33  r_kinder
 * Intermediate commit in case my laptop blows up.
 *
 * Now works quite well with the panel (no start/stop yet). Looking into how
 * to use the gconf stuff to store data.
 *
 * Revision 1.9.4.3  2002/02/28 21:02:12  r_kinder
 * Clean up major cruft.
 *
 * Revision 1.9.4.2  2002/02/25 22:58:54  r_kinder
 * First version that builds (NOTE: WILL NOT RUN!!!)
 *
 * Revision 1.9.4.1  2002/02/24 10:24:21  r_kinder
 * Update to CVS in case my laptop blows up.
 *
 * Revision 1.9  2001/06/28 03:01:28  r_kinder
 * General code cleanup.
 *
 * Revision 1.8  2001/06/12 07:27:20  r_kinder
 * Fix all of the known bugs from 0.3.4-2, add the new user detection code and
 * gui to set up seti@home accounts. Clean up some of the code.
 *
 */

#ifndef _SETI_H
#define _SETI_H

#include <panel-applet.h>

#include <gtk/gtk.h>
#include <libgnomecanvas/libgnomecanvas.h>
#include <libgnomeui/libgnomeui.h>

#include "config.h"


//Indices into the user and unit valid array
#define PERCENT 0
#define SPIKE 1
#define GAUSSIAN 2
#define UNITS 3
#define CPUTIME 4
#define CPUTIMECURRENT 5

typedef enum
{
    VALUE_VALID = 0x00000001,
    VALUE_INVALID = 0x00000002,
    VALUE_DISPLAY = 0x00000004,
    VALUE_HIDE = 0x00000008,
}
setiValueValid_t;

typedef enum _newUserState_t
{
    HANDLE_STATE_1
}
newUserState_t;

//Seti-applet druid widgets we need to track.
typedef struct _setiapplet_gui_druid setiapplet_gui_druid;
struct _setiapplet_gui_druid
{
    GtkWidget  *window;
    GtkWidget  *druid;
    GtkWidget  *firstpage;
    GtkWidget  *page1;
    GtkWidget  *page2;
    GtkWidget  *page3;
    GtkWidget  *page4;
    GtkWidget  *lastpage;
    GtkWidget  *radio_new_account;
    GtkWidget  *entry_new_email;
    GtkWidget  *check_display_new_email;
    GtkWidget  *entry_name;
    GtkWidget  *check_display_name;
    GtkWidget  *entry_existing_email;
    GtkWidget  *entry_postal_code;
    GtkWidget  *combo_entry_country;
    GtkWidget  *combo_entry_location;
};

//Seti-applet properties widgets we need to track.
typedef struct _setiapplet_gui_properties setiapplet_gui_properties;
struct _setiapplet_gui_properties
{
    GtkWidget  *seti_location_text;
    GtkWidget  *units_processed_check;
    GtkWidget  *total_CPU_check;
    GtkWidget  *current_CPU_check;
    GtkWidget  *spike_check;
    GtkWidget  *gaussian_check;
    GtkWidget  *percentage_check;
    GtkWidget  *ui_update_spin;
    GtkWidget  *file_update_spin;
    GtkWidget  *launch_on_start;
    GtkWidget  *nice_val;
    GtkWidget  *extra_parm_text;
    GtkWidget  *use_diff_dir_exe;
    GtkWidget  *seti_alternate_dir;
    GtkWidget  *auto_resize_check;
    GtkWidget  *scale_x;
    GtkWidget  *scale_y;
    GtkWidget  *lock_xy_check;
    GtkWidget  *radar_only_check;
    GtkWidget  *combo_presets;
    GtkWidget  *entry_presets;
};

//User details extracted from the user.sah file
typedef struct _setiapplet_user_info setiapplet_user_info;
struct _setiapplet_user_info
{
    gdouble     units_processed;
    gdouble     cumulative_cpu_time;
};

//Current unit information from the state.sah file.
typedef struct _setiapplet_current_unit setiapplet_current_unit;
struct _setiapplet_current_unit
{
    gdouble     best_spike;
    gdouble     best_gaussian_power;
    gdouble     best_gaussian_score;
    gdouble     percent_complete;
    gdouble     gaus_values[64];
    gdouble     max_gaus;
    gdouble     current_cpu_time;
};

typedef struct _seti_applet_size_t
{
    gboolean    auto_size;
    gboolean    lock_xy;
    gboolean    only_radar;
    short       x;
    short       y;
    short       radar_start;
    PanelAppletOrient orientation;
    gdouble     panel_size;
    gboolean    draw_border;
}
seti_applet_size_t;

#include "seti-applet-skin.h"

//seti-applet widgets we need to track
typedef struct _setiapplet_gui setiapplet_gui;
struct _setiapplet_gui
{
    GtkWidget  *applet;
    GtkWidget  *frame;
    GtkWidget  *align;
    GtkWidget  *the_canvas;
    GnomeCanvasItem *radar_red_item;
    GnomeCanvasItem *radar_green_item;
    GnomeCanvasItem *radar_grey_item;
    GnomeCanvasItem *transparent_item;
    GnomeCanvasItem *title_text_item;
    GnomeCanvasItem *gaus_graph_item;
    GnomeCanvasItem *spike_item;
    GnomeCanvasItem *num_units_item;
    GnomeCanvasItem *cpu_time_item;
    GnomeCanvasItem *cpu_time_current_item;
    GnomeCanvasItem *percentage_item;
    GnomeCanvasItem *current_canvas_item;
    GtkTooltips *tip_text;
    GtkWidget  *seti_console;
    GtkTextBuffer  *seti_console_text;
    GtkWidget  *seti_console_file_sel;
    seti_applet_skin_t *current_skin;
    seti_applet_size_t *custom_size;
    BonoboUIComponent *menu_component;
    PanelAppletBackgroundType bg_type;
    GdkColor bg_colour;
    GdkPixmap *bg_pixmap;
};

//The main (dogs breakfast) structure for the seti-applet.
typedef struct _setiapplet setiapplet;
struct _setiapplet
{
    /*Directory containing seti client */
    gchar      *seti_dir;

    /*fd for piped output from the seti@home process started by this applet */
    gint        seti_output;
    gint        seti_input;

    newUserState_t new_user_state;
    gboolean    registered;     //Is the user registered?

    guint       watch_in;
    guint       watch_hup;

    gchar      *seti_console_buffer;

    gint        current_count;
    gint        previous_status;
    gint        file_version;

    /*update of UI interval (secs) */
    gint        update_interval;
    gint        display_timeout_id;

    gint        show_timeout_id;
    gint        attention_timeout_id;

    gint start_stop_seti_id;

    /*how often the state file is re-read */
    gint        file_update_interval;
    gint        update_state_file_timeout_id;

    gint        update_user_file_timeout_id;

    /*Nice level to run the process as */
    gint        nice_value;

    /*Extra command line options to pass the client */
    gchar      *extra_params;

    /*whether the exe is in a separate dir from the seti root dir */
    gboolean    separate_exe_dir;

    gchar      *seti_exe_dir;

    /*whether to attempt to launch seti@home on applet start */
    gboolean    launch_on_start;

    //Whether to launch xsetiathome on double click.
    gboolean    launch_xseti;

    /* which values read in are valid and which to display */
    setiValueValid_t value_mask[6];

    /* Structures to store the info for the process and the user */
    setiapplet_user_info *user_info;
    setiapplet_current_unit *current_unit_info;

    /* GUI structures */
    setiapplet_gui_druid *druid_gui;
    setiapplet_gui_properties *properties_gui;
    setiapplet_gui *applet_gui;
};

//Exported prototypes
gchar      *re_read_file(gchar *);
void        re_read_state_file(setiapplet *);
void        re_read_user_file(setiapplet *);
void        start_callback(setiapplet *);
void        update_applet_menu(setiapplet *);
void        check_change_applet(PanelApplet *,
                                gpointer);
void        check_change_pixmap(setiapplet *);
void        check_handle_output(gchar *,
                                setiapplet *);
void        gui_warning(gchar *);
void        gui_error(gchar *);
void        panel_applet_preferences_load(setiapplet *,
                                          PanelApplet *);
void        panel_applet_preferences_save(setiapplet *,
                                          PanelApplet *);

#endif
