#include <string.h>
#include <stdio.h>
#include <stdlib.h>

// included functions
void decodecolorname(char *colname, int *r, int *g, int *b);
void *load_resources(char *progname);
char *get_res_value(char *name, char *def_value, void *v_db);
int int_res_value(char *name, int def_value, void *v_db);
int bool_res_value(char *name, int def_value, void *v_db);


#if defined(__APPLE__)

char *load1res(char *resname)
{
	char **h, *p, pname[256]; 
	int l;

	strcpy(pname + 1, resname);
	pname[0] = strlen(resname);
	h = GetNamedResource('TEXT', (ConstStr255Param)pname );
	if(h == NULL) return NULL;
	else	{
		l = GetHandleSize(h);
		p = (char *)malloc(l + 1);
		}
	if(p != NULL) {
		HLock(h);
		memcpy(p, *h, l);
		HUnlock(h);
		p[l] = 0;
		if(p[--l] == '\r') p[l] = 0;
		}
	ReleaseResource(h);
	return p;
}
	
void *load_resources(char *progname)
{
return NULL;	
}


char *get_res_value(char *name, char *def_value, void *v_db)
{
char *p;

p = load1res(name);
if(p != NULL) return p;
else return def_value;
}

void decodecolorname(char *colname, int *r, int *g, int *b)
{
;
}


#elif defined(WIN32) 

#include <fcntl.h>

void decodecolorname(char *colname, int *r, int *g, int *b)
{
;
}

extern "C" {
char *get_prog_dir(void);
}

/* !!! en debut de programme, l'utilisation de stdio fait planter le progr !!! */
void *load_resources(char *progname)
{
char fname[200];
char *buf;
int in, total;
strcpy(fname, get_prog_dir());
strcat(fname, "seaview.ini");
in = open(fname, O_RDONLY);
if(in == -1) return NULL;
total = lseek(in, 0, SEEK_END);
buf = (char *)malloc(total + 1);
if(buf != NULL) {
	lseek(in, 0, SEEK_SET);
	read(in, buf, total);
	buf[total] = 0;
	}
close(in);
return (void *)buf;
}

char *get_res_value(char *name, char *def_value, void *v_db)
{
char *p, *q, *db = (char *)v_db;
static char value[200];
int l;
if(db == NULL) return def_value;
p = db; l = strlen(name);
while(strncmp(p, name, l) != 0 || (*(p + l) != '=' && *(p + l) != ' ') ) {
	p = strchr(p, '\n');
	if(p == NULL) return def_value;
	p++;
	}
p += l;
while( *p == ' ' || *p == '=' ) p++;
q = strchr(p, '\n');
if(q == NULL) q = p + strlen(p);
memcpy(value, p, q - p); value[q - p] = 0; if(value[q - p - 1] == '\r') value[q - p - 1] = 0;
return value;
}

#else

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <FL/x.H>
#include <ctype.h>

void decodecolorname(char *colname, int *r, int *g, int *b)
/* decodes color name and returns rgb in [0,255] */
{
int status;
XColor exact, couleur;
status = XLookupColor(fl_display, fl_colormap, colname, &exact, &couleur);
if(status == 0) return;
*r = couleur.red >> 8;
*g = couleur.green >> 8;
*b = couleur.blue >> 8;
}


void *load_resources(char *progname)
{
XrmDatabase db = NULL;
char *rm, fname[100], Pname[50];
strcpy(Pname, progname); Pname[0] = toupper(Pname[0]);
fl_open_display();
XrmInitialize();
strcpy(fname, "/usr/lib/X11/app-defaults/");
strcat(fname, Pname);
XrmCombineFileDatabase(fname, &db, 1);
rm = getenv("XAPPLRESDIR");
if(rm != NULL) {
	strcpy(fname, rm);
	strcat(fname, "/");
	strcat(fname, Pname);
	XrmCombineFileDatabase(fname, &db, 1);
	}
// ajouter resources de xrdb
rm = XResourceManagerString(fl_display);
if(rm != NULL) XrmMergeDatabases(XrmGetStringDatabase(rm), &db);
rm = XScreenResourceString(ScreenOfDisplay(fl_display, fl_screen));
if(rm != NULL) {
	XrmMergeDatabases(XrmGetStringDatabase(rm), &db);
	XFree(rm);
	}
return (void *)db;
}


char *get_res_value(char *name, char *def_value, void *v_db)
{
static char full_name[100] = "Seaview.";
static const int pre_len = (int)strlen(full_name);
XrmDatabase db = (XrmDatabase)v_db;
char *res_type;
XrmValue valeur;
strcpy(full_name + pre_len, name);
int status = XrmGetResource(db, full_name, NULL, &res_type, &valeur);
return (status ? valeur.addr : def_value);
}

#endif


int int_res_value(char *name, int def_value, void *v_db)
{
int val = def_value;
char *p = get_res_value(name, NULL, v_db);
if( p != NULL ) sscanf(p, "%d", &val);
return val;
}


int bool_res_value(char *name, int def_value, void *v_db)
{
char *p = get_res_value(name, NULL, v_db);
if( p == NULL ) return def_value;
return (*p == 'T' || *p == 't');
}

