#ifdef __APPLE__
#include <Carbon/Carbon.h>

#include "seaview.h"
#include <string.h>
#include <stdio.h>
#include <FL/Fl.H>
#include <FL/Fl_Sys_Menu_Bar.H>
#include <FL/filename.H>
#if TARGET_RT_MAC_MACHO
#include <sys/stat.h>
#include <unistd.h>
#endif

// included functions
int MG_GetInputFName(char *fname, int maxl, char *title);
char *mac_fname_to_roman(char *in);
void fl_ringbell(int a);
extern "C" {
void *memccpy(void *s1, const void *s2, int c, size_t n);
#if ! TARGET_RT_MAC_MACHO
void loop_till_program_ends(void *psn);
void *my_run_program(char *prog, char *arguments, int flavor);
char *OSXpathtoOS9path(const char *newpath);
char *get_prog_dir(void);
#else
int my_system_macho(char *command, char *base_fname);
char *MG_GetBundleResourcesDir(void);
#endif
void PtoC(const void *in, void *out);
void CtoP(const void *in, void *out);
void MGinit_apple_events(void);
void add_apropos(char *progname, void *data);
void show_apropos(Fl_Widget *, void *);
Boolean AppleEventsInstalled ();
OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply, long handlerRefCon);
OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon);
OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon);
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent);
void MG_apple_inits(void);
}
void cre_sys_menu(void );
void windowmenuitem_callback(Fl_Widget *o, void *data);
int find_windowmenuitem(Fl_Window *w);
int add_windowmenuitem(char *name, Fl_Window *w);
void rename_windowmenuitem(const char *name, int rank);
void delete_windowmenuitem(int rank);


extern void use_initial_file(SEA_VIEW *view, char *masename);
extern char *get_next_help_line(void *in, char *line, int lline);

#elif defined(WIN32)

#include <stdarg.h>
#include <Windows.h>
#include <string.h>
#include <direct.h>
#include <stdlib.h>
#include <stdio.h>

/* included functions */
extern "C" {
void my_bell(void);
void *memccpy(void *s1, const void *s2, int c, size_t n);
int mysystem(const char *command);
char *get_prog_dir(void);
void add_to_path(char *dir);
}
char *MG_win32_file_chooser(const char* message, // title of dialog window
        const char* pattern, // optional "mase format\0*.mase\0MSF format\0*.msf\0"
        const char* fname, // default file name
        const char* defext, // default filename extension or NULL
        bool save, // TRUE iff output file selection
        int *pfilterindex); // (inout) pointer to index (from 1) in series of file types in pattern
#endif



void *memccpy(void *s1, const void *s2, int c, size_t n)
{
char *p, *q;
p = (char *)s1; q = (char *)s2;
while(n-- > 0) {
	*p = *(q++);
	if( *(p++) == c) return p;
	}
return 0;
}


#ifdef __APPLE__

void fl_ringbell(int a)
{
SysBeep(a);
}


int MG_GetInputFName(char *fname, int maxl, char *title)
{
  OSStatus          err;
  NavDialogCreationOptions  options;
  NavDialogRef        navDialog;
  NavReplyRecord        navReply;
int         rsult = FALSE;
FSRef fileRef;

  err = NavGetDefaultDialogCreationOptions( &options );
  if(err != noErr) return FALSE;
  options.optionFlags &= !kNavAllowMultipleFiles;
  options.windowTitle = CFStringCreateWithCString(NULL, title, kCFStringEncodingMacRoman);
  err = NavCreateChooseFileDialog( &options, NULL, NULL, NULL, NULL, NULL, &navDialog );
  if(err != noErr) return FALSE;

  // choose the file
  err = NavDialogRun( navDialog );
  CFRelease(options.windowTitle);
  if(err != noErr) return FALSE;
  
  err = NavDialogGetReply( navDialog, &navReply );
  
  // create url to chosen file
  if (err == noErr && navReply.validRecord )
  {    
	err = AEGetNthPtr( &navReply.selection, 1, typeFSRef, NULL, NULL, &fileRef, sizeof( FSRef ), NULL );
    if(err == noErr) {
				err = FSRefMakePath(&fileRef, (UInt8 *)fname, maxl);
				if (err == noErr) rsult = TRUE;
                }
  }  
  NavDisposeReply( &navReply );
  NavDialogDispose( navDialog );
  return rsult;
}


char* MAC_file_chooser(const char* message, const char* pat, const char* fname)
{
	static char pathname[FL_PATH_MAX];
	if( MG_GetInputFName(pathname, FL_PATH_MAX, (char *)message) ) return pathname;
	else return NULL;
}


char *mac_fname_to_roman(char *in)
/* passage codage pathname vers codage MacRoman qui semble ncessaire pour display cran 
*/
{
static char out[250];
CFStringRef mycfs;
Boolean ok;
/* j'ai cru comprendre que les pathnames sont cods en UTF8 */
mycfs = CFStringCreateWithCString(NULL, in, kCFStringEncodingUTF8);
/* et que MacRoman est utilis pour display */
ok = CFStringGetCString(mycfs, out, sizeof(out), kCFStringEncodingMacRoman);
CFRelease(mycfs);
return (ok ? out : in);
}



#if TARGET_RT_MAC_MACHO

int my_system_macho(char *command, char *base_fname)
{
char comfile[300];
FILE *out;
FSRef myref, myterm, frontproc;
LSLaunchFSRefSpec mylaunch;
OSStatus status;
ProcessSerialNumber newpsn, mypsn;

sprintf(comfile, "%s.command", base_fname);
out = fopen(comfile, "w");
fprintf(out, "%s\n", command);
fclose(out);
chmod(comfile, S_IRUSR|S_IXUSR);
status = FSPathMakeRef((const UInt8 *)comfile, &myref, NULL);
LSFindApplicationForInfo(kLSUnknownCreator, CFSTR("com.apple.terminal"), NULL, &myterm, NULL);
mylaunch.appRef = &myterm; // FSRef to the Terminal application
mylaunch.numDocs = 1;
mylaunch.itemRefs = &myref;
mylaunch.passThruParams = NULL;
mylaunch.launchFlags =  kLSLaunchNewInstance ; // run a new Terminal instance
mylaunch.asyncRefCon = NULL;
status = LSOpenFromRefSpec(&mylaunch, &frontproc); // frontproc becomes FSRef to newly started Terminal
if(status == noErr) {
	GetFrontProcess(&newpsn); // the newly started Terminal
	GetCurrentProcess(&mypsn); // seaview
    sleep(2);
	fl_cursor(FL_CURSOR_DEFAULT, FL_BLACK, FL_BLACK);
	SetFrontProcess(&mypsn);
	status = fl_choice(
		"Wait for alignment completion in Terminal window.",
		"Ignore or interrupt alignment", "Alignment completed", NULL) ? 0 : 1 ; 
	// try to kill only a newly started Terminal and not something else
	if( FSCompareFSRefs(&frontproc, &myterm) == noErr) KillProcess(&newpsn);
	}
unlink(comfile);
return status != noErr;
}


char *MG_GetBundleResourcesDir(void)
{
ProcessSerialNumber psn;
FSRef fsref;
static char fname[300];

GetCurrentProcess(&psn);
GetProcessBundleLocation(&psn, &fsref);
FSRefMakePath(&fsref, (UInt8 *)fname, sizeof(fname)-1);
strcat(fname, "/Contents/Resources"); 
return fname;
}

#else

void loop_till_program_ends(void *psn)
{
ProcessInfoRec pinfo;
OSErr err;

while(1) {
    Fl::wait();
    pinfo.processInfoLength = sizeof(ProcessInfoRec);
    pinfo.processName = NULL;
    pinfo.processAppSpec = NULL;
    err = GetProcessInformation((ProcessSerialNumber *)psn, &pinfo);
    if(err == procNotFound) break;
  }
}


void *my_run_program(char *prog, char *arguments, int flavor)
{
LaunchParamBlockRec pbloc;
FSSpec fspec;
OSErr err;
char pfname[256];
ProcessSerialNumber *pinfo;
ScrapRef scrapref;
OSStatus etat;
Size l;
UInt32 count;

if(arguments != NULL) { // put arguments in the scrap under the specified flavor
	etat = ClearCurrentScrap();  // indispensable !
	etat = GetCurrentScrap(&scrapref);
	l = strlen(arguments);
	etat = PutScrapFlavor(scrapref, flavor, kScrapFlavorMaskNone, l, arguments);
	}
strcpy(pfname + 1, prog );
pfname[0] = strlen(pfname+1);
err = FSMakeFSSpec(0, 0, (ConstStr255Param)pfname, &fspec);
if(err != noErr) return NULL;

pbloc.launchControlFlags = launchContinue | launchNoFileFlags ;
pbloc.launchBlockID = extendedBlock;
pbloc.launchEPBLength = extendedBlockLen;
pbloc.launchAppParameters = NULL;
pbloc.launchAppSpec = &fspec;
err = LaunchApplication(&pbloc);
pinfo = (ProcessSerialNumber *)malloc(sizeof(ProcessSerialNumber));
*pinfo = pbloc.launchProcessSN;
return ( err == noErr ? pinfo : NULL) ;
}


static void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl)
{
FSRef myFSRef, pFSRef;
FSCatalogInfo myinfo;
static int  anErr = noErr;
char *p, *q;
static char buffer[1000], name[256];
FSSpec fsspec;

p = buffer;
anErr = FSpMakeFSRef(myFSS, &myFSRef);
while(1) {
	anErr = FSGetCatalogInfo(&myFSRef, kFSCatInfoParentDirID, &myinfo, NULL, &fsspec, &pFSRef);
	PtoC(fsspec.name, name);
	/* add the file or dir name to the end of buffer in reverse orientation */
	q = name + strlen(name) - 1;
	while(q >= name) { *p = *q; q--; p++; }
	if(myinfo.parentDirID == fsRtParID) break; /* detect when top level is reached */
	*p = ':'; p++;
	myFSRef = pFSRef;
	}
*p = 0;
/* invert buffer into fname */
maxl--;
if(maxl > strlen(buffer)) maxl = strlen(buffer);
q = buffer + maxl - 1;
p = fname;
while(q >= buffer) { *p = *q; q--; p++; }
fname[maxl] = 0;
}


char *get_prog_dir(void)
/* returns the pathname of the directory containing the running program
*/
{
FSSpec fspec;
ProcessInfoRec info;
ProcessSerialNumber psn;
OSErr err;
static char myname[300];
char *p;

info.processInfoLength = sizeof(ProcessInfoRec);
info.processName = NULL;
info.processAppSpec = &fspec;
err = GetCurrentProcess(&psn);
if(err != noErr) return NULL;
err = GetProcessInformation(&psn, &info);
if(err != noErr) return NULL;
MG_FSSpecToPathname(&fspec, myname, sizeof(myname) );
p = strrchr(myname, ':');
if(p == NULL) return NULL;
*p = 0;
return myname;
}


char *OSXpathtoOS9path(const char *OSXpath /* syntax /disk/dir/fname */)
{
static char OS9path[1000];
FSRef myref;
FSSpec fsspec;

FSPathMakeRef((const unsigned char *)OSXpath, &myref, NULL);
FSGetCatalogInfo(&myref, 0, NULL, NULL, &fsspec, NULL);
MG_FSSpecToPathname(&fsspec, OS9path, sizeof(OS9path));
return OS9path; /* syntax disk:dir:fname */
}
#endif


void PtoC(const void *in, void *out)
{
char *vin = (char *)in;
char *vout = (char *)out;
int l = *vin;

if(l > 0) memcpy(vout, vin + 1, l);
vout[l] = 0;
}


void CtoP(const void *in, void *out)
{
char *vout = (char *)out;
int l;
if(in == NULL) l = 0;
else	{
	l = strlen( (char *)in );
	memcpy(vout + 1, in, l);
	}
vout[0] = l;
}


void MGinit_apple_events(void)
{
	OSErr err;
	AEEventHandlerUPP	gAEEventHandlerUPPODoc;
	AEEventHandlerUPP	gAEEventHandlerUPPOApp;
	AEEventHandlerUPP	gAEEventHandlerUPPPDoc;
    Boolean aEvents;
	aEvents = AppleEventsInstalled();
	if (aEvents) {
		gAEEventHandlerUPPODoc = NewAEEventHandlerUPP(MyHandleODoc);
		gAEEventHandlerUPPOApp = NewAEEventHandlerUPP(MyHandleOApp);
		gAEEventHandlerUPPPDoc = NewAEEventHandlerUPP(MyHandlePDoc);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenDocuments, gAEEventHandlerUPPODoc,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenApplication, gAEEventHandlerUPPOApp,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEPrintDocuments, gAEEventHandlerUPPPDoc,0, 0);
	}
}


void add_apropos(char *progname, void *data)
{  
static Fl_Menu_Item item = {"", 0, show_apropos, 0, 0};
OSStatus err;
MenuRef mr;
char title[256];
Str255 ptitle;

const unsigned char apple_glyph[2] = "\p\024";

Fl_Sys_Menu_Bar *smb = new Fl_Sys_Menu_Bar(0,0,0,0);
Fl_Menu_Item empty = {0, 0, NULL, 0, 0};
smb->menu( &empty ); // indispensable pour initialiser fl_sys_menu_bar
mr = NewMenu(1, apple_glyph);
InsertMenu(mr, 0);
sprintf(title, "About %s", progname);
CtoP(title, ptitle);
err = InsertMenuItemText(mr, ptitle, 0);
err = SetMenuItemRefCon(mr, 1, (UInt32) (&item));
item.user_data_ = data;
}


extern Fl_Sys_Menu_Bar *fl_sys_menu_bar;
void cre_sys_menu(Fl_Callback *newwindow_callback, void *data)
{
static const Fl_Menu_Item items[] = {
	{"Window", 0, NULL, 0, FL_SUBMENU} ,
	{0},
	{0}
	};

fl_sys_menu_bar->menu(items);
}

void windowmenuitem_callback(Fl_Widget *o, void *data)
{
((Fl_Window *)data)->show();
SEA_VIEW *view = (SEA_VIEW *)((Fl_Window *)data)->user_data();
view->DNA_obj->take_focus();
}

int find_windowmenuitem(Fl_Window *w)
{
MenuRef ref = GetMenuRef(2);
UInt32 p;
Fl_Menu_Item *pitem;
int i, count = CountMenuItems(ref);
for(i = 1; i <= count; i++) {
	GetMenuItemRefCon(ref, i, &p);
	pitem = (Fl_Menu_Item *)p;
	if(pitem->user_data_ == w) return i;
	}
return 0;
}

int add_windowmenuitem(char *name, Fl_Window *w)
{
MenuRef ref = GetMenuRef(2);
MenuItemIndex rank;
CFStringRef mycfs = CFStringCreateWithCString(NULL, (name == NULL ? "<empty>" : name), kCFStringEncodingMacRoman);
AppendMenuItemTextWithCFString(ref, mycfs, 0, 0, &rank);
CFRelease(mycfs);
Fl_Menu_Item *item = (Fl_Menu_Item *)calloc(1, sizeof(Fl_Menu_Item));
item->user_data_ = w;
item->callback_ = windowmenuitem_callback;
SetMenuItemRefCon(ref, rank, (UInt32)item);
return rank;
}

void rename_windowmenuitem(const char *name, int rank)
{
MenuRef ref = GetMenuRef(2);
CFStringRef mycfs = CFStringCreateWithCString(NULL, name, kCFStringEncodingMacRoman);
SetMenuItemTextWithCFString(ref, rank, mycfs);
}

void delete_windowmenuitem(int rank)
{
UInt32 p;
GetMenuItemRefCon(GetMenuRef(2), rank, &p);
free((void *)p);
DeleteMenuItem( GetMenuRef(2) , rank);
}

void show_apropos(Fl_Widget *w, void *data)
{
static Fl_Window *about = NULL;
char line[100], *p;

if(about == NULL) {
	about = new Fl_Window(600, 400, "About seaview");
	Fl_Browser *br = new Fl_Browser(1, 1, about->w() - 2, about->h() - 2);
	about->end();
	br->add("");
#if TARGET_RT_MAC_MACHO
	p = get_full_path((char *)data);
	data = (void *)fopen(p, "r");
	if(data == NULL) return;
#else
	get_next_help_line(data, NULL, 0);
#endif
	get_next_help_line(data, line, sizeof(line));
	if(strncmp(line, ">>>", 3) != 0) br->add(line);
	while(TRUE) {
		get_next_help_line(data, line, sizeof(line));
		if(strncmp(line, ">>>", 3) == 0) break;
		while( (p=strchr(line,'\r')) != NULL) *p = 0;
		while( (p=strchr(line,'\n')) != NULL) *p = 0;
		br->add(line);
		}
#if TARGET_RT_MAC_MACHO
	fclose((FILE*)data);
#else
	get_next_help_line(data, NULL, 0);
#endif
	}
about->show();
}



/***********************************************************************/
Boolean AppleEventsInstalled ()
{
	OSErr err;
	long  result;

	err = Gestalt (gestaltAppleEventsAttr, &result);
	return (!err && ((result >> gestaltAppleEventsPresent) & 0x0001));
											// return TRUE if there is no
											// error and the proper bit of
											// result is set
}

/***********************************************************************/
pascal OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply, long handlerRefCon)
{
	FSRef myFSRef;	
	AEDescList	docList;
	OSErr	err;
	long	itemsInList;
	char masename[300];

	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
			&docList);
	if (err) return err;

	err = MyGotRequiredParams (theAppleEvent);
	if (err) return err;

	err = AECountItems (&docList, &itemsInList);

	err = AEGetNthPtr (&docList, 1, typeFSRef, NULL,
		NULL,  &myFSRef, sizeof(FSRef), NULL);
	if (err) return err;
	
	err = FSRefMakePath(&myFSRef, (UInt8 *)masename, sizeof(masename));
	Fl_Window *w = Fl::first_window();
	if(w != NULL) {
		while(w->window() != NULL) w = w->window();
		SEA_VIEW *view = (SEA_VIEW *)w->user_data();
		use_initial_file(view, masename);
		}
	err = AEDisposeDesc (&docList);
	return noErr;
}

/***********************************************************************/
pascal OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon)
{
	AEDescList	docList;
	OSErr	err;
	long	itemsInList;
	
	// get the direct parameter--a descriptor list--and put it into a docList
	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
									&docList);
	if (err)
			return err;

	// check for missing parameters
	err = MyGotRequiredParams (theAppleEvent);
	if (err)
			return err;

	// count the number of descriptor records in the list
	err = AECountItems (&docList, &itemsInList);

	// now get each descriptor record from the list, coerce the returned
	// data to an FSSpec record, and open the associated file
	
	return noErr;

}

/***********************************************************************/
pascal OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon)
{
	// Ouverture de l'appli
	return noErr;
}


/***********************************************************************/
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent)
{
	DescType	returnedType;
	Size	actualSize;
	OSErr	err;

	err = AEGetAttributePtr (theAppleEvent, keyMissedKeywordAttr,
									typeWildCard, &returnedType, nil, 0,
									&actualSize);
	if (err == errAEDescNotFound)	// you got all the required parameters
			return noErr;
	else if (!err)				// you missed a required parameter
			return errAEEventNotHandled;
	else						// the call to AEGetAttributePtr failed
			return err;
}


void MG_apple_inits(void)
{
#ifdef __APPLE_QUARTZ__
Fl::set_font(FL_COURIER,"Courier");
Fl::set_font(FL_COURIER_BOLD,"Courier Bold");
/* no Courier italic , stay with default Courier New
Fl::set_font(FL_COURIER_ITALIC,"Courier Italic");
Fl::set_font(FL_COURIER_BOLD_ITALIC,"Courier Bold Italic");
*/
#elif defined(__APPLE_QD__)
Fl::set_font(FL_COURIER," Courier");
Fl::set_font(FL_COURIER_BOLD,"BCourier");
Fl::set_font(FL_COURIER_ITALIC,"ICourier");
Fl::set_font(FL_COURIER_BOLD_ITALIC,"PCourier");
#else
error
#endif
}

#endif



#ifdef WIN32


void add_to_path(char *dir)
/* ajoute a la variable PATH la directory dir
teste si deja dedans ou si vide */
{
char *buffer;
int l;

if(dir == NULL || strlen(dir) == 0) return;
buffer = (char *)malloc(10000);
l = GetEnvironmentVariable("PATH", buffer, 10000);
if(l == 0) *buffer = 0;
//fprintf(OUT,"l=%d PATH=%s\n",l,buffer);fflush(OUT);
if(strstr(buffer, dir) != NULL) return;
if(*buffer != 0) strcat(buffer, ";");
strcat(buffer, dir);
SetEnvironmentVariable("PATH", buffer);

//GetEnvironmentVariable("PATH", buffer, sizeof(buffer));
//fprintf(OUT,"PATH=%s\n",buffer);fflush(OUT);

free(buffer);
}

static FILE *out=NULL;

int mysystem(const char *command)
/*
command contains "cmd.exe /c prog.exe args"  or  "prog.exe args"
the first form is compulsory if args contain "> outfile"
prog is searched in dir where calling program was launched, current dir,
windows system dir, windows dir, dirs in PATH.
*/
{
static char buf[100];
STARTUPINFO info;
PROCESS_INFORMATION pi;
int retval;

//if(out==NULL)out=fopen("seaview.log","w");
GetStartupInfo(&info);
//fprintf(OUT,"retour GetStartupInfo \n");fflush(OUT);
retval = CreateProcess(NULL, (char *)command,0,0,0,0,0,_getcwd(buf,sizeof(buf)),&info,&pi);
retval = WaitForSingleObject(pi.hProcess, INFINITE);
//fprintf(out,"retour WaitForSingleObject retval=%d WAIT_FAILED=%d\n",retval,WAIT_FAILED);fflush(out);
return (retval == WAIT_FAILED);
}

char *get_prog_dir(void)
/* returns path of dir where calling program was launched */
{
static char dir[100];
char *line, *p;
int l;

line = GetCommandLine();
//fprintf(OUT,"retour GetCommandLine line=%s\n",line);fflush(OUT);
/* extract 1st word of line or first group delimited by " " */
if(*line == '"') { line++; p = strchr(line, '"'); }
else
	p = strchr(line, ' '); 
if(p == NULL) p = line + strlen(line);
l = p - line;
while( l > 0 && line[l - 1] != '\\' ) l--;
if(l <= 0) return NULL;
memcpy(dir, line, l); dir[l] = 0;
return dir;
}


void my_bell(void)
{
Beep(0,0);
}

char *MG_win32_file_chooser(const char* message, // title of dialog window
        const char* pattern, // optional "mase format\0*.mase\0MSF format\0*.msf\0"
        const char* fname, // default file name
        const char* defext, // default filename extension or NULL
        bool save, // TRUE iff output file selection
        int *pfilterindex) // (inout) pointer to index (from 1) in series of file types in pattern
 {
     static char filenamebuffer[MAX_PATH];
     static OPENFILENAME wreq;
     bool retval;
     
     memset(&wreq, 0, sizeof(wreq));
     wreq.lStructSize = sizeof(OPENFILENAME); 
     wreq.lpstrFilter = pattern;
     if(pattern == NULL) wreq.nFilterIndex = 0;
     else if(pfilterindex != NULL) wreq.nFilterIndex = *pfilterindex;
     else wreq.nFilterIndex = 1;
     if(defext != NULL) wreq.lpstrDefExt = defext;
     wreq.lpstrFile = filenamebuffer;
     wreq.nMaxFile = MAX_PATH;
     wreq.lpstrTitle = message ? message : "Select the filename";
     if(fname) {
       memset(filenamebuffer, 0, MAX_PATH);
       if((filenamebuffer[1] == ':') && (_getdrive() + 'A' - 1 == filenamebuffer[0]))
   strncpy(filenamebuffer, fname + 2, MAX_PATH);
       else
   strncpy(filenamebuffer, fname, MAX_PATH);
     }
     wreq.Flags = OFN_NOCHANGEDIR | OFN_HIDEREADONLY;
     retval = (save ? GetSaveFileName(&wreq) : GetOpenFileName(&wreq));
     if(save && (pfilterindex != NULL) ) *pfilterindex = wreq.nFilterIndex;
     return retval == 0 ? NULL : wreq.lpstrFile;
 }
 

/*
char **split_args(char *all, int *pargc)
{
char *p, *q, **argv;
int l, argc = 0;

// compter les arguments
p = all;
while(*p != 0) {
	argc++;
	if(*p == '"') p = strchr(p+1, '"');
	else p = strchr(p, ' ');
	if(p == NULL) break;
	p++;
	while(*p == ' ') p++;
	}
argv = (char **)malloc(argc * sizeof(char *));
*pargc = argc;
// separer les arguments, enlever les "" encadrantes si presentes
p = all; argc = 0;
while(*p != 0) {
	if(*p == '"') { p++; q = strchr(p, '"'); }
	else q = strchr(p, ' ');
	if(q == NULL) q = p + strlen(p);
	l = q - p; 
	argv[argc] = (char *)malloc(l + 1);
	memcpy(argv[argc], p, l); argv[argc][l] = 0;
	if(*q == 0) break;
	p = q + 1;
	while(*p == ' ') p++;
	argc++;
	}
return argv;
}
*/

#endif
