//============================================================
//
//  strconv.h - Win32 string conversion
//
//============================================================
//
//  Copyright Aaron Giles
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or
//  without modification, are permitted provided that the
//  following conditions are met:
//
//    * Redistributions of source code must retain the above
//      copyright notice, this list of conditions and the
//      following disclaimer.
//    * Redistributions in binary form must reproduce the
//      above copyright notice, this list of conditions and
//      the following disclaimer in the documentation and/or
//      other materials provided with the distribution.
//    * Neither the name 'MAME' nor the names of its
//      contributors may be used to endorse or promote
//      products derived from this software without specific
//      prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY AARON GILES ''AS IS'' AND
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
//  EVENT SHALL AARON GILES BE LIABLE FOR ANY DIRECT,
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGE (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
//  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
//  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//============================================================

#ifndef __WIN_STRCONV__
#define __WIN_STRCONV__

#include "mamecore.h"



//============================================================
//  FUNCTION PROTOTYPES
//============================================================

CHAR *astring_from_utf8(const char *s) ATTR_MALLOC;
char *utf8_from_astring(const CHAR *s) ATTR_MALLOC;

WCHAR *wstring_from_utf8(const char *s) ATTR_MALLOC;
char *utf8_from_wstring(const WCHAR *s) ATTR_MALLOC;

#ifdef UNICODE
#define tstring_from_utf8	wstring_from_utf8
#define utf8_from_tstring	utf8_from_wstring
#else // !UNICODE
#define tstring_from_utf8	astring_from_utf8
#define utf8_from_tstring	utf8_from_astring
#endif // UNICODE



#endif // __WIN_STRCONV__
