#include "rpggame.h"

namespace game
{
	bool needminimap() { return mapdata != NULL; }

	void quad(int x, int y, int xs, int ys)
	{
		glBegin(GL_TRIANGLE_STRIP);
		glTexCoord2f(0, 0); glVertex2i(x,    y);
		glTexCoord2f(1, 0); glVertex2i(x+xs, y);
		glTexCoord2f(0, 1); glVertex2i(x,    y+ys);
		glTexCoord2f(1, 1); glVertex2i(x+xs, y+ys);
		glEnd();
	}

	float abovegameplayhud(int w, int h) {return 1;}

	VARP(minimapmaxdist, 128, 1536, 16384);
	FVARP(minimapfrac, .1, .5, 1);
	VARP(minimapup, 0, 1, 1);
	VARP(minimap, 0, 1, 1);

	void drawcompass()
	{
		vec pos = vec(player1->o).sub(minimapcenter).mul(minimapscale).add(0.5f);
		glColor3f(1, 1, 1);
		glDisable(GL_BLEND);
		bindminimap();

		float offset = min<float>(getworldsize() * minimapfrac / 2.0f, minimapmaxdist);
		glBegin(GL_TRIANGLE_FAN);
		loopi(16)
		{
			vec dir(M_PI * i / 8.0f, 0);

			glTexCoord2f(pos.x + dir.x * offset * minimapscale.x, pos.y + dir.y * offset * minimapscale.y);
			glVertex2i(128 * dir.x, 128* dir.y);
		}
		glEnd();

		glEnable(GL_BLEND);

		settexture("data/rpg/hud/compass", 3);
		quad(-130, -130, 260, 260);
	}

	void drawcompassplayers()
	{
		const int coords[4][2] = { {0,0}, {1, 0}, {1, 1}, {0,1}};

		float offset = min<float>(getworldsize() * minimapfrac / 2.0f, minimapmaxdist);
		settexture("data/rpg/hud/player", 3);

		glBegin(GL_QUADS);
		loopv(curmap->objs)
		{
			rpgent *d = curmap->objs[i];
			if(d->type() != ENT_CHAR)
				continue;

			vec pos = vec(d->o).sub(player1->o).div(offset); pos.z = 0;
			if(pos.magnitude() >= 1)
				continue;

			vec col = d->blipcol();
			glColor4f(col.x, col.y, col.z, min<float>(1, 3 - 3 * pos.magnitude()));

			loopi(4)
			{
				vec dir((d->yaw) * RAD + M_PI * i / 2.0f, 0);
				glTexCoord2f(coords[i][0], coords[i][1]);
				glVertex2i(128 * pos.x + 15 * dir.x, 128 * pos.y + 15 * dir.y);
			}
		}
		glEnd();
	}

	//you need to be in the correct state already
	void drawblip(int x, int y, int sz)
	{
		glTexCoord2f(0, 0); glVertex2i(x     , y     );
		glTexCoord2f(1, 0); glVertex2i(x + sz, y     );
		glTexCoord2f(1, 1); glVertex2i(x + sz, y + sz);
		glTexCoord2f(0, 1); glVertex2i(x     , y + sz);
	}

	void drawbar(int x, int y, int dx, int dy, float progress = 1, vec col = vec(1, 1, 1))
	{
		glColor3f(0, 0, 0);
		glTexCoord2f(0, 0); glVertex2i(x, y);
		glTexCoord2f(1, 0); glVertex2i(x + dx, y);
		glTexCoord2f(1, 1); glVertex2i(x + dx, y + dy);
		glTexCoord2f(0, 1); glVertex2i(x, y + dy);

		x += 3;
		y += 3;
		dx -= 6;
		dy -= 6;

		glColor3fv(col.v);
		glTexCoord2f(0, 0);        glVertex2i(x, y);
		glTexCoord2f(progress, 0); glVertex2i(x + dx * progress, y);
		glTexCoord2f(progress, 1); glVertex2i(x + dx * progress, y + dy);
		glTexCoord2f(0, 1);        glVertex2i(x, y + dy);
	}

	void drawcompassblips()
	{
		float offset = min<float>(getworldsize() * minimapfrac / 2.0f, minimapmaxdist);
		settexture("data/rpg/hud/blip", 3);

		glBegin(GL_QUADS);
		loopv(curmap->projs)
		{
			projectile &p = *curmap->projs[i];
			vec pos = vec(p.o).sub(player1->o).div(offset); pos.z = 0;
			if(pos.magnitude() >= 1)
				continue;

			glColor4f(1, 0, 0, min<float>(1, 3 - 3 * pos.magnitude()));

			drawblip(128 * pos.x - 3, 128 * pos.y - 3, 6);
		}
		loopv(curmap->blips)
		{
			blip &b = curmap->blips[i];

			vec pos = vec(b.o).sub(player1->o).div(offset); pos.z = 0;
			if(pos.magnitude() >= 1)
				continue;

			glColor4f(b.col.x, b.col.y, b.col.z, min<float>(1, 3 - 3 * pos.magnitude()));

			drawblip(128 * pos.x + b.size / 2.0f, 128 * pos.y + b.size / 2.0f, b.size);

			//TODO add ability to change textures - be sure to sort them first
		}
		glEnd();
	}

	void gameplayhud(int w, int h)
	{
		if(!mapdata || !curmap || rpggui::open())
			return;

		glPushMatrix();
		float scale = min (w / 1600.0f, h / 1200.0f);
		glScalef(scale, scale, 1);

		float right = w / scale, bottom = h / scale; // top and left are ALWAYS 0

		if(camera::cutscene)
		{
			camera::render(ceil(right), ceil(bottom));
			glPopMatrix();
			return;
		}

		if(DEBUG_WORLD)
		{
			glPushMatrix();
			glTranslatef(right - 300, 350, 0);
			glScalef(.5, .5, .5);

			draw_textf("curmap: %s", 0, 0, curmap->name);
			draw_textf("blips: %i", 0, 50, curmap->blips.length());
			draw_textf("objects: %i", 0, 100, curmap->objs.length());
			draw_textf("persistent effects: %i", 0, 150, curmap->aeffects.length());
			draw_textf("projectiles: %i", 0, 200, curmap->projs.length());

			draw_textf("scripts: %i", 0, 300, scripts.length());
			draw_textf("effects: %i", 0, 350, effects.length());
			draw_textf("statuses: %i", 0, 400, statuses.length());
			draw_textf("items: %i", 0, 450, items.length());
			draw_textf("ammo types: %i", 0, 500, ammotypes.length());
			draw_textf("characters: %i", 0, 550, chars.length());
			draw_textf("factions: %i", 0, 600, factions.length());
			draw_textf("objects: %i", 0, 650, objects.length());
			draw_textf("mapscripts: %i", 0, 700, mapscripts.length());
			draw_textf("recipes: %i", 0, 750, recipes.length());

			draw_textf("variables: %i", 0, 850, variables.length());
			draw_textf("tips: %i", 0, 900, tips.length());

			glPopMatrix();
		}

		if(minimap)
		{
			glPushMatrix();

			glTranslatef(right - 160, bottom - 160, 0);
			if(minimapup)
				glRotatef(player1->yaw + 180, 0, 0, -1);

			drawcompass();
			drawcompassblips();
			drawcompassplayers();

			glPopMatrix();
		}

		if(player1->state != CS_DEAD)
		{
			if(rpgscript::hover)
			{
				defformatstring(hover)("%s", rpgscript::hover->getname());
				int tw = min(text_width(hover), 768);
				draw_text(hover, (right - tw) / 2.0f, bottom / 2.0f + 16, 255, 255, 255, 255, -1, 768);
			}

			//draw HP/MP and EXP bars/
			settexture("data/rpg/hud/hbar", 3);
			glBegin(GL_QUADS);
			drawbar(32, bottom - 144, 192, 32, player1->health / (float) player1->base.getmaxhp(), vec(1, 0, 0));
			drawbar(32, bottom - 104, 192, 32, player1->mana / (float) player1->base.getmaxmp(), vec(0, 0, 1));
			{
				float progress = (player1->base.experience - stats::neededexp(player1->base.level - 1)) / (float) (stats::neededexp(player1->base.level) - stats::neededexp(player1->base.level - 1));
				if(progress < 0)
					drawbar(32, bottom - 64, 192, 32, 1, vec(1, .25 ,.25));
				else
					drawbar(32, bottom - 64, 192, 32, min<float>(1, progress), vec(0, .8, .9));
			}
			glEnd();

			glColor3f(1, 1, 1);

			//draw status effect icons along the right side of the screen
			vector<statusgroup *> efx;

			loopv(player1->seffects)
			{
				efx.add(statuses[player1->seffects[i]->group]);
			}
			loopv(curmap->aeffects)
			{
				areaeffect *effect = curmap->aeffects[i];
				if(player1->o.dist(effect->o) <= effect->radius || player1->feetpos().dist(effect->o) <= effect->radius)
					efx.add(statuses[effect->group]);
			}
			loopv(efx)
			{
				statusgroup *status = efx[i];
				settexture(status->icon ? status->icon : DEFAULTICON, 3);
				quad(right - 66, i * 66 + 128, 64, 64);
			}

			//draw icons at the bototm to signify the currently equipped weapons and ammo
			{
				equipment *left = NULL, *right = NULL, *quiver = NULL;
				loopv(player1->equipped)
				{
					use_weapon *usable = (use_weapon *) items[player1->equipped[i].base]->uses[player1->equipped[i].use];
					if(usable->type != USE_WEAPON)
						continue;

					if(usable->slots & SLOT_LHAND)
						left = &player1->equipped[i];
					if(usable->slots & SLOT_RHAND)
						right = &player1->equipped[i];
					if(usable->slots & SLOT_QUIVER)
						quiver = &player1->equipped[i];
				}

				if(player1->lastaction > lastmillis)
					glColor3f(.5, .5, .5);
				else
					glColor3f(1, 1, 1);

				settexture("data/rpg/hud/empty", 3);
				quad(256, bottom - 160, 128, 128);
				quad(416, bottom - 160, 128, 128);
				quad(640, bottom - 160, 128, 128);

				if(left)
				{
					settexture(items[left->base]->icon ? items[left->base]->icon : DEFAULTICON, 3);
					quad(256, bottom - 160, 128, 128);
				}

				if(right)
				{
					settexture(items[right->base]->icon ? items[right->base]->icon : DEFAULTICON, 3);
					quad(416, bottom - 160, 128, 128);
				}

				if(quiver)
				{
					settexture(items[quiver->base]->icon ? items[quiver->base]->icon : DEFAULTICON, 3);
					quad(640, bottom - 160, 128, 128);
				}

				defformatstring(ammo)("%i", quiver ? player1->getitemcount(quiver->base) : 0);
				draw_text(ammo, 784, bottom - 128, 255, 255, 255);
			}

			if(player1->attack && player1->charge)
			{
				settexture("data/rpg/hud/hbar", 3);

				float charge = min<float>(player1->attack->maxcharge, (float)player1->charge / player1->attack->charge);
				glBegin(GL_QUADS);
				drawbar(544, bottom - 256, 512, 64, charge / player1->attack->maxcharge, charge < player1->attack->mincharge ? vec(1, 0, 0) : vec(0, 1, 0));
				glEnd();

				glColor4f(.8, .8, .4, .9);
				float barrier = player1->attack->mincharge / player1->attack->maxcharge * 512;
				quad(544 + barrier, bottom - 256, 8, 64);
			}
		}

		glPopMatrix();
	}

	int clipconsole(int w, int h)
	{
		return 0;
	}

	const char *defaultcrosshair(int index)
	{
		return editmode ? "data/edit" : "data/crosshair";
	}

	int selectcrosshair(float &r, float &g, float &b)
	{
		if(editmode)
		{
			r = b = 0.5;
		}
		return editmode;
	}
}