/*
 * robutils.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include "robutils.h"
#include "robtrans.h"

#include <rtstring.h>

using namespace lrt;

namespace rt {

// statics
bool NoBreakSection::breakOccured = false;
NoBreakSection* NoBreakSection::inside = 0;

// my break handler
void NoBreakSection::breakHandler(System::BreakType type)
{
	breakOccured = true;
	System::println(_("\nJust a moment, please..."));
}

NoBreakSection::NoBreakSection(bool ignoreBreak)
	: ignoreBreak(ignoreBreak)
{
	enter();
}

NoBreakSection::~NoBreakSection()
{
	leave();
}

void NoBreakSection::enter()
{
	// called twice?
	if(inside) {
//		System::print(String("[Don't enter ") + String((int)this, 16) + ".]");
		return;
	}
//	System::print(String("[Enter ") + String((int)this, 16) + ".]");
	// install handler
	breakOccured = false;
	System::setOnBreak(breakHandler, true);
	inside = this;
}

void NoBreakSection::leave()
{
	// called twice?
	if(inside != this) {
//		System::print(String("[Don't leave ") + String((int)this, 16) + ".]");
		return;
	}
//	System::print(String("[Leave ") + String((int)this, 16) + ".]");
	// remove handler
	System::setOnBreak(0, true);
	inside = 0;
	// handle deferred break
	if(!ignoreBreak && breakOccured)
		System::exit(255 /*, "Deferred user break."*/);
	breakOccured = false;
}


}; // namespace

