/*
 * robtrans.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// NO include guard here, since you may have to include this file several times. 

/** @file
  * Support for translating the program's on-screen output. 
  * The implementation uses the wxWidgets Internationalization functions
  * and will only work when RoboTour is compiled with wxWidgets support. 
  * Otherwise, all operations are no-ops.
  */

namespace lrt {
	class String; 
} // namespace

namespace rt {

	/** Searches the loaded message catalogs for a translation of the given string. */
	lrt::String getTranslation(const char* str);

	/** Gets the language code of the language that has been selected at startup. 
	  * Examples are: @c "de_DE" for language and counter, @c "de" for language only
	  * and the empty string @c "" if no language has been selected. */
	lrt::String getLanguageCode(); 

} // namespace


// Undefine macros, if they have been defined before
#include "robuntrans.h"


// Convenience macros
#ifdef __WXWIN__
/// Search for the translated string and return it.
#	define _(str) (rt::getTranslation(str).cStr())
/// Mark a string for translation. Does nothing in fact.
#	define _N(str) (str)

#else // no wxWidgets -> no translation
#	define _(str) (str)
#	define _N(str) (str)
#endif

