/*
 * wxini.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WXX_WXINI_H__
#define __WXX_WXINI_H__

class wxObject;
class wxHashTable;

#define wxxINI_AVG_GROUPSIZE 32		// used for the hashtables

class wxxIniSection;
class wxxIniOption;

class wxxIniFile : public wxObject  
{
public:
	wxxIniFile();
	~wxxIniFile();

	void AddSection(wxxIniSection* section);
	bool DelSection(const wxString& name);
	wxxIniSection* GetSection(const wxString& name);
	wxxIniSection& operator[](const wxString& name);

	// warning: modifies the First() / Next() position of the IniFile and of all IniSections
	bool Write(const wxString& file); 
	bool Read(const wxString& file);

	void First();
	wxxIniSection* Next();
	// returns number of sections
	size_t GetCount();

private:
	wxHashTable* hash;
};

class wxxIniSection : public wxObject
{
public:
	wxxIniSection(const wxString& name);
	~wxxIniSection();

	const wxString& GetName() const;

	wxString Get(const wxString& name) const;
	inline wxString operator[](const wxString& name) const { return Get(name); }
	wxString& operator[](const wxString& name);
	long GetLong(const wxString& name, long def = 0) const;
	bool GetBool(const wxString& name, bool def = true) const;
	void Set(const wxString& name, const wxString& value);
	void Set(const wxString& name, long value);
	void Set(const wxString& name, bool value);

	bool Del(const wxString& name);
	
	void First();
	wxxIniOption* Next();
	// returns number of options
	size_t GetCount(); 

private:
	wxString name;
	wxHashTable* hash;
};

class wxxIniOption : public wxObject
{
public:
	wxxIniOption();
	wxxIniOption(const wxString& name);
	wxxIniOption(const wxString& name, const wxString& value);
	wxxIniOption& operator=(const wxString& value);


	wxString name, value;
};

#endif 
