/*
 * wxfsel.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WXX_WXFSEL_H__
#define __WXX_WXFSEL_H__

#include <wx/wx.h>

class wxxFselWindow : public wxPanel 
{
public:
	wxxFselWindow(wxWindow* parent, wxWindowID id, const wxString& label, const wxString& initialFile, 
		bool selectFolder = false, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL, 
		const wxString& name = wxT("fsel"));
	~wxxFselWindow();

	// By default, the text control cannot be edited directly.
	// Use SetTextReadOnly(false) to change this behaviour. 
	void SetTextReadOnly(bool ro);
	wxString GetFile();

private:
	void OnSelButton(wxCommandEvent& event);

	wxTextCtrl* myText;
	bool selectFolder;
};


#endif
