/*
 * robotop.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __ROBOTOP_ROBOTOP_H__
#define __ROBOTOP_ROBOTOP_H__

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------

#include <wx/wx.h>
#include <wx/config.h>

// ----------------------------------------------------------------------------
// private classes
// ----------------------------------------------------------------------------

// Define a new application type, each program should derive a class from wxApp
class RoboTopApp : public wxApp
{
public:
	// override base class virtuals
	// ----------------------------

	// this one is called on application startup and is a good place for the app
	// initialization (doing it here and not in the ctor allows to have an error
	// return: if OnInit() returns false, the application terminates)
	virtual bool OnInit();

	bool CheckConfig();

	~RoboTopApp();

private:
	void InitTranslation(); 

	wxConfigBase* globalConfig; // so that it can be deleted
	wxLocale myLocale; 
};

// Define a new frame type: this is going to be our main frame
class MainFrame : public wxMDIParentFrame
{
public:
	// ctor(s)
	MainFrame( const wxString& title, const long style );
	wxMenuBar* CreateMenu();

	// event handlers (these functions should _not_ be virtual)
	void OnNew(wxCommandEvent& event);
	void OnOpen(wxCommandEvent& event);
	void OnQuit(wxCommandEvent& event);
	void OnSettings(wxCommandEvent& event);
	void OnFullscreen(wxCommandEvent& event);
	void OnHelp(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void OnClose(wxCloseEvent& event);

private:
	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE();
};

// declare the wxGetApp() function
DECLARE_APP(RoboTopApp)

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

// IDs for the controls and the menu commands
enum
{
	// menu items
	RoboTop_New = 100,
	RoboTop_Open,
	RoboTop_Quit,
	RoboTop_Settings,
	RoboTop_Fullscreen,
	RoboTop_Help,
	RoboTop_About
};


#endif // file
