/*
 * rtresource.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include "rtresource.h"

#include "rtmap.h"
#include "rtfile.h"
#include "rtstreams.h"

namespace lrt{


StringMap<lrt_resource_type> Resource::resources;

void Resource::addResource(const lrt_resource_type& res)
{
	resources.put(res.name, res);
}

InputStream* Resource::getResource(const String& name)
{
	File file(name);
	if(file.exists())
		return new FileInputStream(file, false);
	if(resources.isSet(name))
		return new ResourceInputStream(resources.get(name));
	
	return 0;
}

/** ResourceInputStream */

ResourceInputStream::ResourceInputStream(const lrt_resource_type& res) : 
	resource(res), pos(0), markPos(0)
{	
}

int ResourceInputStream::read()
{
	if(pos < resource.length)
		return resource.data[pos++];
	return -1;
}

bool ResourceInputStream::eos()
{
	if(pos < resource.length)
		return false;
	else 
		return true;
}

bool ResourceInputStream::markSupported()
{
	return true;
}

void ResourceInputStream::mark()
{
	markPos = pos;
}

void ResourceInputStream::reset()
{
	pos = markPos;
}


} // namespace

