/*
 * rtetools.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/**\file
  * Helper utilities (String conversion) for the Epoc platform.
  */

#ifndef __LRT_EPOC_TOOLS__
#define __LRT_EPOC_TOOLS__

#include <rtstring.h>

#include <e32std.h>

/////////////// Helper stuff ////////////
#ifdef __SYMBIAN32__

#ifdef _UNICODE
#include <e32std.h>
TBuf<256> ESTRING(const lrt::String& str);
#else
#include <e32def.h>
/// Converts a lrt::String to an Epoc descriptor. 
#define ESTRING(str) _L(((unsigned char*)str.cStr()))
#endif

#ifdef _UNICODE
lrt::String MYSTRING(const TDesC& str);
#define MYSTRING_C(str) MYSTRING(str)
#else
/// Creates an lrt::String from a modifyable Epoc descriptor.
#define MYSTRING(str) lrt::String((char*)(str.PtrZ()))
/// Creates an lrt::String from a constant Epoc descriptor.
#define MYSTRING_C(str) lrt::String((const char *)(str.Des().PtrZ()))
#endif

#endif
////////////////////////////////////////


#endif

