#ifndef __RT_WXVIS__
#define __RT_WXVIS__

#include "robbase.h"
#include "robmanage.h"
#include <rtcollect.h>

//using namespace rt; 
//using namespace lrt; 

#include <wx/wx.h>
#include <wx/listctrl.h>
#include <wx/splitter.h>
#include <wx/artprov.h>
#include "robwxext.h"
#include "robwxstruct.h"

// eventclasses //
class RoboTourEvent; 
class DebugEvent;
// guiclasses //
class RobVisFrame; 
class FieldPanel; 
class PlayerListCtrl; 
class PlayerInfoDialog;
class BotErrFilterDialog;
class DebugDialog;
class HistoryCtrl;
class BotPainter; 
// end predefines //


// my event system ///////////////
// the event handler function
typedef void (wxEvtHandler::*RoboTourEventFunction)(RoboTourEvent&);
typedef void (wxEvtHandler::*DebugEventFunction)(DebugEvent&);

// available event types
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_RT_SHOW_TYPE, wxEVT_USER_FIRST + 200)
    DECLARE_EVENT_TYPE(EVT_RT_INITSIM_TYPE, wxEVT_USER_FIRST + 201)
    DECLARE_EVENT_TYPE(EVT_RT_STEPSIM_TYPE, wxEVT_USER_FIRST + 202)
    DECLARE_EVENT_TYPE(EVT_RT_EXITSIM_TYPE, wxEVT_USER_FIRST + 203)
	DECLARE_EVENT_TYPE(EVT_RT_STEPTOUR_TYPE, wxEVT_USER_FIRST + 204) 
	DECLARE_EVENT_TYPE(EVT_RT_PLAYER_TYPE, wxEVT_USER_FIRST + 205) 
	DECLARE_EVENT_TYPE(EVT_RT_SETUPDLG_TYPE, wxEVT_USER_FIRST + 206)
	DECLARE_EVENT_TYPE(EVT_RT_MSGINFO_TYPE, wxEVT_USER_FIRST + 207)
	DECLARE_EVENT_TYPE(EVT_RT_MSGWARN_TYPE, wxEVT_USER_FIRST + 208)
	DECLARE_EVENT_TYPE(EVT_RT_MSGERROR_TYPE, wxEVT_USER_FIRST + 209)
	DECLARE_EVENT_TYPE(EVT_RT_MSGROBERR_TYPE, wxEVT_USER_FIRST + 210)

	DECLARE_EVENT_TYPE(EVT_DEBUG_UPDATE_TYPE, wxEVT_USER_FIRST + 250)
	DECLARE_EVENT_TYPE(EVT_DEBUG_CLOSE_TYPE, wxEVT_USER_FIRST + 251)
END_DECLARE_EVENT_TYPES()

// event table macros
#define EVT_RT_SHOW(fn)     DECLARE_EVENT_TABLE_ENTRY( EVT_RT_SHOW_TYPE,     -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_INITSIM(fn)  DECLARE_EVENT_TABLE_ENTRY( EVT_RT_INITSIM_TYPE,  -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_STEPSIM(fn)  DECLARE_EVENT_TABLE_ENTRY( EVT_RT_STEPSIM_TYPE,  -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_EXITSIM(fn)  DECLARE_EVENT_TABLE_ENTRY( EVT_RT_EXITSIM_TYPE,  -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_STEPTOUR(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_RT_STEPTOUR_TYPE, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_PLAYER(fn)   DECLARE_EVENT_TABLE_ENTRY( EVT_RT_PLAYER_TYPE,   -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_SETUPDLG(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_RT_SETUPDLG_TYPE, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_MSGINFO(fn)  DECLARE_EVENT_TABLE_ENTRY( EVT_RT_MSGINFO_TYPE,  -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_MSGWARN(fn)  DECLARE_EVENT_TABLE_ENTRY( EVT_RT_MSGWARN_TYPE,  -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_MSGERROR(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_RT_MSGERROR_TYPE, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_RT_MSGROBERR(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_RT_MSGROBERR_TYPE, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_DEBUG_UPDATE(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_DEBUG_UPDATE_TYPE, -1, -1, (wxObjectEventFunction) & fn, NULL ),
#define EVT_DEBUG_CLOSE(fn) DECLARE_EVENT_TABLE_ENTRY( EVT_DEBUG_CLOSE_TYPE,-1, -1, (wxObjectEventFunction) & fn, NULL ),

// my event class
class RoboTourEvent : public wxEvent
{
    DECLARE_DYNAMIC_CLASS(RoboTourEvent)
public:
	RoboTourEvent(int eventType = EVT_RT_SHOW_TYPE);
	RoboTourEvent(const RoboTourEvent& evt);
    wxEvent* Clone() const;

	void LoadSimData(rt::Simulation* sim, int simNum);
	void LoadBotData(rt::Simulation* sim);
	void LoadTourData(rt::Simulation* sim, const lrt::Array<rt::TourResult>& tr, const rt::TourInitInfo& ti);
	void LoadPlayerData(int playerNum, rt::Simulation* sim, const lrt::Array<rt::TourResult>& tr);
	
	lrt::Vector<BotInfo> botData;
	SimInfo simData;
	lrt::Vector<TourInfo> tourData;
	rt::TourInitInfo tourInitData;
	PlayerInfo playerData;
	MsgInfo msgData;
	void* retData;
};

// my event class 2
class DebugEvent : public wxEvent
{
    DECLARE_DYNAMIC_CLASS(DebugEvent)
public:
	DebugEvent(int eventType = EVT_DEBUG_UPDATE_TYPE);
	//DebugEvent(const DebugEvent& evt);
    wxEvent* Clone() const;

	DebugInfo data; 
};


///////////////////////////////////////////////////////////////////////////////
////////////// utility class to paint robots onto DCs or into image lists
////////////// on creation, it will load default colours & stored settings
class BotPainter {
public:
	BotPainter();
	BotPainter(const BotPainter&); // need just copy the colours
	~BotPainter(); 

	void LoadSettings();
	void StoreSettings();
	
	void SetProgramColour(int progNum, const wxColour& col);
	wxColour& GetProgramColour(int progNum);
	int GetProgramColourCount();

	void DrawBot(BotInfo& bot, wxDC& dc, const wxPoint& position, int size, bool bg = true);
	wxImageList* CreateImageList(int imgSize);

private:
	int GetFrameStyle(int botType);
	void CalcPoints(int dir, int fieldSize, wxPoint* points);
	lrt::Vector<wxColour> programColours;
	wxBrush* backBrush,* botBrush;
	wxPen* backPen,* botPen,* activePen;

};

////////////////// GUI classes
/* abstract */ class FieldDisplay 
{
public:
	virtual ~FieldDisplay() {}
	virtual void EnterSim(const SimInfo& info) = 0; // will be called on all fields
	virtual void StepSim(const lrt::Vector<BotInfo>& status) = 0; // will only be called on the active field
	virtual void ExitSim() = 0; // will be called on all fields
	virtual void Update(bool force = false) = 0;  // redraw now!
	virtual bool Show(bool doShow = true) = 0; // should be implemented by calling wxWindow::Show();
	virtual void HandleProgramColourChange() = 0; 
	virtual wxWindow* GetAsWindow() = 0; 
protected:
	FieldDisplay(RobVisFrame* vframe) : vframe(vframe) {}
	RobVisFrame* vframe; 
};

class NoFieldPanel : public wxControl, public FieldDisplay
{
public:
	NoFieldPanel(wxWindow* parent, RobVisFrame* vframe, wxWindowID id);
	~NoFieldPanel();
	void EnterSim(const SimInfo& info);
	// set status & draw field
	void StepSim(const lrt::Vector<BotInfo>& status);
	void ExitSim();
	// repaint field
	void Update(bool force = false); 
	bool Show(bool doShow); 
	void HandleProgramColourChange();
	wxWindow* GetAsWindow(); 

	DECLARE_EVENT_TABLE()
private:
	void OnPaint(wxPaintEvent& event);
};

class FieldPanel : public wxControl, public FieldDisplay
{
public:
	FieldPanel(wxWindow* parent, RobVisFrame* vframe, wxWindowID id);
	~FieldPanel();

	void EnterSim(const SimInfo& info);
	// set status & draw field
	void StepSim(const lrt::Vector<BotInfo>& status);
	void ExitSim();
	
	virtual wxSize DoGetBestSize() const;

	// repaint field
	void Update(bool force = false); 

	bool Show(bool doShow);
	void HandleProgramColourChange();
	wxWindow* GetAsWindow(); 

	DECLARE_EVENT_TABLE()
private:
	void Paint(wxDC& device, bool forceDraw);
	void OnPaint(wxPaintEvent& event);
	void OnClick(wxMouseEvent& event);
	//void OnSize(wxSizeEvent& event);
	
	// pixel sizes;
	int fieldSize, xOffset, yOffset;

	// field status
	bool inSim; 
	SimInfo simInfo; 
	lrt::Vector<BotInfo> status, prevStatus; 
};

class PlayerListCtrl : public ImprovedListCtrl
{
public:
	PlayerListCtrl(wxWindow* parent, RobVisFrame* vframe, wxWindowID id);
	~PlayerListCtrl();

	void Update(const lrt::Vector<TourInfo>& tourData);
	
	void SetImageIfNeeded(long row, int image);
	void SetItemIfNeeded(long row, int col, const wxString& text);
	void SetItemIfNeeded(long row, int col, int num) { SetItemIfNeeded(row, col, wxString::Format("%d", num)); }

	void HandleProgramColourChange();

	DECLARE_EVENT_TABLE()
private:
	RobVisFrame* vframe;
	int numFieldSize; 

	lrt::Vector< lrt::Vector<wxString> > strings;
	lrt::Vector<int> images; bool haveImgList; int imgListSize; 


	void OnClick(wxListEvent&);
};

class RobVisFrame : public wxFrame
{
public:
	static RobVisFrame* theVisFrame; 
	static GuiInfo guiInfo;

	RobVisFrame();
	~RobVisFrame(); 

	virtual bool Destroy(); // override to tell this to anyone (guiInfo.isDestroyed)

	BotPainter& GetBotPainter() { return painter; }

	void HandleProgramColourChange();
	void HandleFieldClick(int fieldX, int fieldY); // called by the FieldPanels when a field (bot) is clicked
	bool HandleDebugDialogClose(int debugID); // called by the DebugDialogs when they want to be closed
	
	DECLARE_EVENT_TABLE()
private:
	// wxConfig support
	void LoadSettings();
	void StoreSettings();

	bool AddStdIcon(wxImageList* iList, wxArtID id, const wxSize& sz);
	void AddMessage(const wxString& msg, int icon);
	bool Filter(int errid);
	void SetActiveFieldDisplay(int num, bool toogleTools = false); 

	void OnProgramColourMenu(wxCommandEvent&);
	void OnBotErrFilterMenu(wxCommandEvent&);
	void OnUseHQMenu(wxCommandEvent&);
	void OnShowMessageList(wxCommandEvent&);
	void OnNewTourMenu(wxCommandEvent&);
	void OnAbortTourMenu(wxCommandEvent&);
	void OnHideMenu(wxCommandEvent&);
	void OnExitMenu(wxCommandEvent&);
	void OnHelp(wxCommandEvent&); 
	void OnAbout(wxCommandEvent&); 
	void OnClose(wxCloseEvent&);

	void OnShow(RoboTourEvent&);
	void OnInitSim(RoboTourEvent&);
	void OnStepSim(RoboTourEvent&);
	void OnExitSim(RoboTourEvent&);
	void OnStepTour(RoboTourEvent&);
	void OnPlayerInfo(RoboTourEvent&);
	void OnSetupDlg(RoboTourEvent&);

	void OnMsgInfo(RoboTourEvent&);
	void OnMsgWarn(RoboTourEvent&);
	void OnMsgError(RoboTourEvent&);
	void OnMsgRobErr(RoboTourEvent&);

	void OnDebugUpdate(DebugEvent&);
	void OnDebugClose(DebugEvent&);

	void OnStart(wxCommandEvent&);
	void OnStartLock(wxCommandEvent&);
	void OnSlowMode(wxCommandEvent&);
	void OnPause(wxCommandEvent&);
	void OnAbort(wxCommandEvent&);
	void OnSpeed(wxCommandEvent&);
	void OnNoField(wxCommandEvent&);
	void On2DField(wxCommandEvent&);
	void On3DField(wxCommandEvent&);

//	void OnSize(wxSizeEvent& event);
	SimInfo simInfo; 
	wxPanel* infoPanel;
	lrt::Vector<FieldDisplay*> field; 
	lrt::Map<int, DebugDialog*> debugDialogs;
	lrt::Vector<int> ignoreDebugIDs;
	FieldDisplay* activeField; int activeFieldNum;
	PlayerListCtrl* players;
	HistoryCtrl* history;
	ImprovedListCtrl* messages;
	wxStaticText* tSimCount,* tCycleCount;
	wxSplitterWindow* hSplitter,* vSplitter;
	BotPainter painter;

	BotErrFilterDialog* errFilter;

	bool haveSim; // is there a current simulation?
	int curCycle, numBotColours; /* curSimNum is now in simInfo. */
	lrt::Time framesStart;
	int numFramesSince; 
};

enum { //IDs
	RVF_Start = 100,
	RVF_StartLock,
	RVF_Speed,
	RVF_Slow,
	RVF_Pause,
	RVF_Abort,
	RVF_NoField,
	RVF_2DField,
	RVF_3DField,
	RVF_Colours,
	RVF_Filter,
	RVF_UseHQ,
	RVF_ShowMsg,
	RVF_NewTour, 
	RVF_AbortTour,
	RVF_HideWin,
	RVF_HelpIndex,
	RVF_About,
};

class PlayerInfoDialog : public wxDialog
{
public:
	PlayerInfoDialog(wxFrame* parent, const lrt::Vector<lrt::Pair<lrt::String, lrt::String> >& info);
};


#endif //__RT_WXVIS__

