#ifdef __RT_OPENGL__ // You need to enable this to compile OpenGL related stuff

#ifndef __RT_WXGL_H__
#define __RT_WXGL_H__

#include "robwxvis.h"
#define NOMINMAX // Windows headers need this, otherwise they will #define min to something!
#include <wx/wx.h>
#include <wx/glcanvas.h>

class GLFieldPanel : public wxGLCanvas, public FieldDisplay 
{
public:
	GLFieldPanel(wxWindow* parent, RobVisFrame* vframe, wxWindowID id);
	~GLFieldPanel();
	void EnterSim(const SimInfo& info);
	// set status & draw field
	void StepSim(const lrt::Vector<BotInfo>& status);
	void ExitSim();
	// repaint field
	void Update(bool force = false); 
	bool Show(bool doShow); 
	void HandleProgramColourChange();
	wxWindow* GetAsWindow(); 

	void SetUseHQ(bool hq) { useHQ = hq; }
	bool GetUseHQ() { return useHQ; }

	DECLARE_EVENT_TABLE()
private:
	void OnPaint(wxPaintEvent& event);
	void OnSize(wxSizeEvent& event);
	void OnEraseBackground(wxEraseEvent& event);
	void OnKeyDown(wxKeyEvent& event);

	void OnLeftDown(wxMouseEvent& event);
	void OnRightDown(wxMouseEvent& event);
	void OnLeftUp(wxMouseEvent& event);
	void OnRightUp(wxMouseEvent& event);
	void OnMouseMotion(wxMouseEvent& event);
	void OnMouseWheel(wxMouseEvent& event);
	void OnEnterWindow(wxMouseEvent& event);
	void OnLeaveWindow(wxMouseEvent& event);

	void InitGL();
	void GenLists();
	void LoadTextures();
	void DrawField(int x, int z, const BotInfo& info);
	void MakeGLColour(const wxColour& wc, float factor, float* dest);
	int LoadTexture(const wxBitmap& bmp);
	void UpdateBigFieldIfNeeded();

	bool glInitDone;
	bool useHQ; // high quality setting enabled?
	float posDist, angUp, angSide; // camera position
	int listBot, listBotHQ, listHead;
	void* quadric; // the GLU quadric object

	unsigned int texField, texIset[3];
	int listBigField; int lbfX, lbfY;

	SimInfo simInfo;
	lrt::Vector<BotInfo> status; 

	wxPoint dragPoint;
	bool isClickEvent; // for LeftUp(): if isClickEvent, the user didn't drag while the button was down

	// for click point computation
	double fieldModelMatrix[16], projMatrix[16];
	int viewport[4];
};


#endif // include file
#endif // __RT_OPENGL__ enabled
