#ifndef __RT_WX_CLASSEX__
#define __RT_WX_CLASSEX__

// Contains some small extension classes for wxWindows. 

#include <wx/listctrl.h>
#include <wx/splitter.h>

class ImprovedListCtrl : public wxListCtrl {
public:
	ImprovedListCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style = wxLC_ICON, 
		const wxValidator& validator = wxDefaultValidator, const wxString& name = "listCtrl");
	void SetGrowableCol(int col);

	DECLARE_EVENT_TABLE()
private:
	void OnSize(wxSizeEvent&);

	int growableCol;
};

class ImprovedSplitter : public wxSplitterWindow {
public:
	ImprovedSplitter(wxWindow* parent, wxWindowID id, const wxPoint& point = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style=wxSP_3D, const wxString& name = "splitterWindow");

	DECLARE_EVENT_TABLE()
private:
	void OnErase(wxEraseEvent&);
};

template <class W> class NoFlickerWindow : public W {
public:
	NoFlickerWindow() 
	{
		Connect(-1, wxEVT_ERASE_BACKGROUND, (wxObjectEventFunction) &NoFlickerWindow<W>::OnErase);
	}

private:
	void OnErase(wxEraseEvent&) { /* do nothing  */ }
};

#endif // file
