#ifndef __RT_ROBUTILS__
#define __RT_ROBUTILS__

#include <rtsystem.h>

namespace rt {

/// a section of code which should not be abortable by the user.
/// It is protected by a breakHandler which defers the break until
/// the section is finished. (You can also ignore the break completely.)
class NoBreakSection {
public: // static:
	static void breakHandler(lrt::System::BreakType type);
public:
	/// enters the section automatically
	NoBreakSection(bool ignoreBreak = false);
	/// leaves the section automatically
	~NoBreakSection();

	/// re-enters the section 
	void enter();
	/// leaves the section. If we don't ignore breaks, and the
	/// user in fact breaked during the section, exits the program now. 
	void leave();

private: // static:
	static bool breakOccured; // was there a break inside the section?
	static NoBreakSection* inside; // are we inside a section? if yes, it's that one
private:
	bool ignoreBreak; 
};

}; // namespace

#endif
