#ifndef __RT_GLOBALS__
#define __RT_GLOBALS__

#include <rtsystem.h>
#include <rtmath.h>
#include <rtini.h>

//using namespace lrt;

// You must not include anything else from RoboTour in this file.
#include "robvars.h"


namespace rt {
// fwd declaration
class ErrorHandler;

/*****************************************************************************/
/* The global variables for the game - also known as the OptionSet (RCO)     */
/*****************************************************************************/

class Globals{
public:
	rint fields;
	rint fieldsX;
	rint fieldsY;
	rint enableElim;
	rint elim;
	unsigned long timeout;
	rint maxCreateDur;
	rint maxSleepDur;
	rint maxInstrDur;
	rint maxGeneration;
	rint enableRC3Instr;
	rint enableMultitasking;
	rint enableFAT;
	rint enableLifetime;
	rint enableNutcracker; 
	rint firstRobotMobile;
	rint minId;
	rint maxId;

	rint maxInstr;
	rint maxBanks;
	rint maxVars;
	rint maxTasks;//
	rint maxMybots;//
	unsigned long maxLifetime;//

	rint durDie;
	rint durMove;
	rint durTurn;
	rint durAjump;//
	rint durJump;
	rint durBjump;
	rint durScan;
	rint durFarscan;//
	rint durFarscanPerField;//
	rint durSet;
	rint durAdd;
	rint durSub;
	rint durMul;//
	rint durDiv;//
	rint durMod;//
	rint durMin;//
	rint durMax;//
	rint durTrans;
	rint durTransPerInstr;
	rint durRtrans;//
	rint durRtransPerInstr;//
	rint durComp;
	rint durNcomp;//
	rint durGcomp;//
	rint durLcomp;//
	rint durRandom;//
	rint durCreate;
	rint durCreatePerBank;
	rint durCreateMulMobile;
	rint durCreateAddMobile;//
	rint durCreateAdvISet;
	rint durCreateSuperISet;

	rint durBreak;//
	rint durInit;//
	rint durSeize;//
	rint durResume;//
	rint durQuit;//

	rint durRemote;

	/// Read the global variables (the option set) from a RCO file.
	bool getGlobals(const lrt::String& filename);

	/// Creates a new Globals object. Errors will be reported using the given ErrorHandler.
	Globals(const ErrorHandler* errHandler) : errHandler(errHandler) {}
	~Globals() {}

private:
	const ErrorHandler* errHandler;

	// Fetches a rint from an ini file section
	rint getRint( lrt::IniSection& sec, const char* name, rint def = -1, rint min = MIN_RINT, rint max = MAX_RINT);

	// Fetches an int from an ini file section
	int getInt( lrt::IniSection& sec, const char* name, int def = -1, int min = lrt::Math::MIN_INT, int max = lrt::Math::MAX_INT);
};



} // namespace

#endif

