// rtsound.cpp: Implementierung der Klasse Sound.
//
//////////////////////////////////////////////////////////////////////

#include "rtsound.h"
#include "rtstring.h"
#include "rtfile.h"

// actual implementation

#ifdef __WIN32__
  #include "rtsound.win32.cpp"
#else
  #ifdef __UNIX__
    #include "rtsound.unix.cpp"
  #else
    #include "rtsound.nosound.cpp"
  #endif // __UNIX__
#endif //__WIN32__

// system-independent functions

namespace lrt {

String Sound::resolve(const String& logicalSoundName)
{
	String soundfile = logicalSoundName.replace('/', File::separatorChar);
	soundfile += getExtension();

	String soundfolder("sounds");
	soundfolder += File::separator;
	File execfolder = File::getExecutableFile().getParentFile();

	if(File(soundfile).exists()) return soundfile;

	if(File(execfolder, soundfile).exists()) 
		return execfolder.getName() + soundfile;
	if(File(execfolder, soundfolder + soundfile).exists()) 
		return execfolder.getName() + soundfolder + soundfile;

	return String();
}

bool Sound::isPresent(const String& logicalSoundName)
{
	return (resolve(logicalSoundName) != "");
}


} // namespace
