// char.cpp: Implementierung der Klasse Char.
//
//////////////////////////////////////////////////////////////////////

#include "rtchar.h"
#include "rtmath.h"

namespace lrt {

const int Char::MAX_RADIX = 36;

bool Char::isDigit(char ch, int radix)
{
	if(((ch - '0') >= 0) && ((ch - '0') < Math::min(radix, 10))) 
		return true;
	if(radix > 10)
		if(isLetter(ch))
		{
			int nv = lowerCase(ch) - 'a';
			if((nv >= 0) && (nv < (radix - 10)))
				return true;
		}
	return false;
}

/// private, so they're never called
Char::Char()
{

}

Char::~Char()
{

}

} // namespace

