if(FALSE) {
setGlyphs.ggobi <-
#
# Sets the glyph type and/or size for 
# one or more rows/observations of the specified
# ggobi instance.
function(ids, type = rep(-1,length(ids)), size = rep(-1, length(ids)), .data = 1, .gobi = getDefaultGGobi())
{
 if(missing(type) & missing(size))
  stop("Must specify either or both type and size")

 if(!is.integer(type)) {
   type <- mapGlyphType(type)
 }

 k <- max(length(ids),length(type), length(size))
 ids <- rep(as.integer(ids), length=k)
 type <- rep(as.integer(type), length=k)
 size <- rep(as.integer(size), length=k)

 size  <- as.integer(size)

 if(!is.integer(ids)) {
   ids <- mapRowIds(ids, .gobi = .gobi)
 }

  if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

 .GGobiCall("setCaseGlyphs", type, size, ids, .data, .gobi = .gobi)
}
}

setVariableNames.ggobi <-
#
# the arguments must be named
# and the name of the argument should identify
# the existing variable. The value of the argument
# is used as the new name.
#
function(..., .data = 1, .gobi=getDefaultGGobi())
{
  args <- c(...)
  ids <- as.integer(getVariableIndex.ggobi(names(args), .gobi=.gobi) - 1)
  

   # get rid of those that didn't match.
  if(any(is.na(ids))) {
    warning(paste("some names did not match the existing names: ", paste(names(args)[is.na(ids)], collapse=", ")))
    which <- !is.na(ids)
    args <- args[which]
    ids <- ids[which]
  }

  if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

  .GGobiCall("setVariableNames", ids, as.character(args), .data, .gobi = .gobi)
}
