#include "Rgtk.h"
#include "gtkUtils.h"

USER_OBJECT_ R_internal_getSignalNames(GtkType type);
USER_OBJECT_ R_createGtkType(GtkType type, const char *name);
USER_OBJECT_ R_createGtkSignalId(guint id, const char *val);
USER_OBJECT_ R_internal_getSignalInfo(guint id);
/**
 Gets a character vector giving the names of the types
 of the object and its ancestor types, in young-to-old
 order.

   .Call("R_getObjectTypeHierarchy", gtkWindow())
 gives 
  [1] "GtkWindow"    "GtkBin"       "GtkContainer" "GtkWidget"    "GtkObject"   

  (in my setup).

  @note relies on accessing the GtkType field directly in the GtkObject.
     Could break in the future if this structure changes!
     How does one get the type of an instance?
 
 */
USER_OBJECT_
R_getObjectTypeHierarchy(USER_OBJECT_ sobj)
{
  GtkType type;
  GtkObject *obj;


  obj = GTK_OBJECT(getPtrValue(sobj));
  if(!GTK_IS_OBJECT(obj)) {
   PROBLEM "Non-GTK object passed to getObjectTypeHierarchy"
   ERROR;
  }
  type = GTK_OBJECT_TYPE(obj);
  
  return(R_internal_getTypeHierarchy(type));
}

USER_OBJECT_
R_getTypeHierarchy(USER_OBJECT_ sobj)
{
  GtkType type;
  type = (GtkType) NUMERIC_POINTER(sobj)[0];
  
  return(R_internal_getTypeHierarchy(type));
}

USER_OBJECT_
R_internal_getTypeHierarchy(GtkType type)
{
  USER_OBJECT_ ans;
  int n = 0;
  GtkType orig = type;

  while(type != 0 && type != GTK_TYPE_INVALID) {
     type = gtk_type_parent(type);   
     n++;
  }

  PROTECT(ans = NEW_CHARACTER(n));
  n = 0;
  type = orig;
  while(type != GTK_TYPE_INVALID) {
     const char *val;
     val = gtk_type_name(type);
     SET_STRING_ELT(ans, n, COPY_TO_USER_STRING(val));
     n++;
     type =  gtk_type_parent(type);   
  }
  UNPROTECT(1);

  return(ans);
}

/**
 Gets the name of the type of the object.
 */
USER_OBJECT_
R_getObjectTypeName(USER_OBJECT_ sobj)
{
    USER_OBJECT_ ans;

    GtkObject *obj;
    GtkType type;
    char *val;

    obj = GTK_OBJECT(getPtrValue(sobj));
    type = GTK_OBJECT_TYPE(obj);
    val = gtk_type_name(type);
    PROTECT(ans = NEW_CHARACTER(1));
    SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(val));
    UNPROTECT(1);

    return(ans);
}

USER_OBJECT_
R_getTypeFromName(USER_OBJECT_ name)
{
    char *val; 
    GtkType type;
    val = CHAR_DEREF(STRING_ELT(name, 0));
    type = gtk_type_from_name(val);

    if( type == GTK_TYPE_INVALID) {
      PROBLEM "No type for %s", val
      ERROR;
    }

    return(R_createGtkType(type, val));
}

USER_OBJECT_
R_getObjectType(USER_OBJECT_ sobj)
{
    USER_OBJECT_ ans;

    GtkObject *obj;
    GtkType type;

    obj = GTK_OBJECT(getPtrValue(sobj));
    type = GTK_OBJECT_TYPE(obj);

    ans = R_createGtkType(type, NULL); 
    return(ans);
}

USER_OBJECT_
R_createGtkType(GtkType type, const char *name)
{
    USER_OBJECT_ ans;

    PROTECT(ans = NEW_NUMERIC(1));
    NUMERIC_DATA(ans)[0] = type;
    if(name == NULL)
       name = gtk_type_name(type);

    if(!name) {
      PROBLEM "object has not Gtk type"
      ERROR;
    }

    SET_NAMES(ans, asRCharacter(name));
    SET_CLASS(ans, asRCharacter("GtkType"));
    UNPROTECT(1);

    return(ans);
}

USER_OBJECT_
R_getSignalNamesByType(USER_OBJECT_ className)
{
    GtkType type;

    type = (GtkType)  NUMERIC_DATA(className)[0];
    if(type == 0 || type == GTK_TYPE_INVALID) {
	PROBLEM "No type for class %s",
	    CHAR_DEREF(STRING_ELT(className, 0))
        ERROR;
    }
    return(R_internal_getSignalNames(type));
}


USER_OBJECT_
R_getSignalNames(USER_OBJECT_ sobj)
{
    GtkType type;
    GtkObject *obj;

    obj = GTK_OBJECT(getPtrValue(sobj));
    type = GTK_OBJECT_TYPE(obj);
    if(type == 0 || type == GTK_TYPE_INVALID) {
	PROBLEM "No type for object"
        ERROR;
    }
    return(R_internal_getSignalNames(type));
}

USER_OBJECT_
R_internal_getSignalNames(GtkType type)
{
    GtkObjectClass *klass;
    int i;
    USER_OBJECT_ ans;


    klass = gtk_type_class(type);
    if(!klass) {
       PROBLEM "Cannot get class corresponding to the type"
       ERROR;
    }

    PROTECT(ans = NEW_LIST(klass->nsignals));
    for(i = 0; i < klass->nsignals; i++) { 
        SET_VECTOR_ELT(ans, i, R_createGtkSignalId(klass->signals[i], NULL));
    }
    UNPROTECT(1);

    return(ans);
}

USER_OBJECT_
R_createGtkSignalId(guint id, const char *val)
{
    USER_OBJECT_ ans;
    PROTECT(ans = NEW_NUMERIC(1));

    NUMERIC_DATA(ans)[0] =  id;
    if(val == NULL)
        val =  gtk_signal_name(id);

    SET_CLASS(ans, asRCharacter("GtkSignalId"));
    SET_NAMES(ans, asRCharacter(val));

    UNPROTECT(1);

    return(ans);
}

USER_OBJECT_
R_gtkGetSignalInfo(USER_OBJECT_ sid)
{
    return(R_internal_getSignalInfo(NUMERIC_DATA(sid)[0]));
}

enum {SIGNAL_SLOT, PARAMS_SLOT, RETURN_SLOT, IS_USER_SLOT, FLAGS_SLOT, OBJECT_SLOT, SIGNAL_INFO_NUM_SLOTS};

USER_OBJECT_
R_internal_getSignalInfo(guint id)
{
    USER_OBJECT_ ans, params, names;
    GtkSignalQuery *info;
    int i;

    info = gtk_signal_query(id);
    PROTECT(ans = NEW_LIST(SIGNAL_INFO_NUM_SLOTS));
    PROTECT(names = NEW_CHARACTER(SIGNAL_INFO_NUM_SLOTS));
    SET_STRING_ELT(names, RETURN_SLOT, COPY_TO_USER_STRING("returnType"));
    SET_STRING_ELT(names, SIGNAL_SLOT, COPY_TO_USER_STRING("signal"));
    SET_STRING_ELT(names, PARAMS_SLOT, COPY_TO_USER_STRING("parameters"));
    SET_STRING_ELT(names, OBJECT_SLOT, COPY_TO_USER_STRING("objectType"));
    SET_STRING_ELT(names, IS_USER_SLOT, COPY_TO_USER_STRING("isUserSignal"));
    SET_STRING_ELT(names, FLAGS_SLOT, COPY_TO_USER_STRING("runFlags"));

    SET_VECTOR_ELT(ans, IS_USER_SLOT, params = NEW_LOGICAL(1));
     LOGICAL_DATA(params)[0] = info->is_user_signal;

/* Has to be handled as a flag. */
    SET_VECTOR_ELT(ans, FLAGS_SLOT, params = NEW_INTEGER(1));
     INTEGER_DATA(params)[0] = info->signal_flags;

    SET_VECTOR_ELT(ans, OBJECT_SLOT, R_createGtkType(info->object_type, NULL));
    SET_VECTOR_ELT(ans, RETURN_SLOT, R_createGtkType(info->return_val, NULL));
    SET_VECTOR_ELT(ans, SIGNAL_SLOT, R_createGtkSignalId(info->signal_id, info->signal_name));

    SET_VECTOR_ELT(ans, PARAMS_SLOT, params = NEW_LIST(info->nparams));
    for(i = 0; i < info->nparams; i++)
	SET_VECTOR_ELT(params, i, R_createGtkType(info->params[i], NULL));

    SET_NAMES(ans, names);

    g_free(info);
    UNPROTECT(2);

    return(ans);
}
