\name{setDataFrame.ggobi}
\alias{setDataFrame.ggobi}
\title{Sets the data for a ggobi instance from a data frame.}
\description{
 This sets the variables being displayed by the ggobi instance
to the columns in the specified data frame, using all its
rows as records. This allows one to create data dynamically
in R and not write it to a file to have ggobi display it.
}
\usage{
setDataFrame.ggobi(data, name= description, description =
deparse(sys.call()[[2]]), add=TRUE, id = TRUE, .gobi=getDefaultGGobi())
}
\arguments{
  \item{data}{the data frame (rectangular ``table'' of values) to use in
    the ggobi displays. The values are converted to real/numeric values
    and can now contain NAs which are `missing' in GGobi.
    }
  \item{name}{the name by which to refer to this dataset and identify it in the variable panel by tab name.}
  \item{description}{a description of the data for use in window titles
    and }
  \item{add}{a logical value indicating whether to append this newly loaded dataset
  to the existing collection (\code{TRUE}), or to replace that collection with this
  one dataset (\code{FALSE}).}
  \item{id}{identifiers for the particular records to be set. By
    default, this applies to the first n observations.}
  \item{.gobi}{the ggobi instance whose data is to be replaced with those in the data frame.}
}
\details{
This discard all the existing plots and data sets in the ggobi instance
and re-initializes it with the new data.

Since ggobi now supports multiple data sets within a ggobi instance,
in the near future, we will provide an option to add this data frame
as a data source in the ggobi instance.
}
\value{
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{ggobi}}
\code{\link{setData.ggobi}}
\code{\link{setDataFile.ggobi}}
}

\examples{
 data(mtcars)
 g <- ggobi(mtcars)
 setDataFrame.ggobi(mtcars, .gobi = g)

  # Put a missing value in the dataset
 mtcars[1, 1] <- NA
  # Now load it
 g <- ggobi(mtcars)

  # Now retrieve the dataset and verify the
  # the NA is in the result from GGobi.
 g[[1]][,]
}
\keyword{visualization}
\keyword{graphics}
