\name{setActivePlot.ggobi}
\alias{setActivePlot.ggobi}
\alias{getActivePlot.ggobi}
\title{Queries or sets the active ggobi plot.}
\description{
 These functions allow one to programmatically
determine which ggobi plot is ``active''. 
The active plot is the one in which the brushing
tool, point identification, etc. operate.
}
\usage{
setActivePlot.ggobi(display, plot=1, .gobi=getDefaultGGobi())
getActivePlot.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{display}{the display which is to be made active and in which the 
    plot that is to get the focus of all subsequent operations resides.}
  \item{plot}{the integer identifying the plot within the display that is to be made active.}
  \item{.gobi}{the ggobi instance whose active plot is being queried or set,
   in which case it identifies the display. This should be an object of class
  \code{ggobi}.}
}
\value{
 Currently, an integer vector identifying the display
and plot that is, in the case of \code{getActivePlot.ggobi}, currently active 
and in the case of \code{getActivePlot.ggobi}, was active before that call.
This allows one to restore existing settings.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
\code{\link{getDisplays.ggobi}}
\code{\link{getPlotCount.ggobi}}
\code{\link{getPlotType.ggobi}}
\code{\link{ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$scatmat(1:3)

    # Now set the 5 plot in the 3x3 matrix
    # (i.e. the middle one) in the second display
    # to be active.
  g$setActivePlot(2, 5)

  g$setMode("Brush")


   # create a new plot and ensure that the active
   # plot was as it was before the plot was created.

      # get the currently active plot
 old <- getActivePlot.ggobi()
      # create a new plot which then becomes active.
 scatmat.ggobi("tars1", "tars2")
      # restore the previous plot as being the active one.
 setActivePlot.ggobi(old, .gobi = g)
}
\keyword{visualization}
\keyword{interactive graphics}
