\name{resolvePlotDescription}
\alias{resolvePlotDescription}
\title{Maps the variable references in a virtual plot description.}
\description{
  Plot descriptions are templates for creating plots.
 The variables in the plot description are virtual in the sense
that they have not been resolved to a particular dataset and variable.
 This function performs that mapping, returning a fully self-describing
 plot description from which a real plot can be instantiated directly. 

This function is not typically called by the user, but used
internally by the \code{\link{plotLayout}} function.
}
\usage{
resolvePlotDescription(desc, .data = 1, .gobi=getDefaultGGobi(), isError = T)
}
\arguments{
  \item{desc}{ the plot description whose variable references are to be resolved.}
  \item{.data}{the dataset in the ggobi instance relative to which the variable
  references will be resolved. This should be specified as a \code{ggobiDataset},
   name or integer.}
  \item{.gobi}{the ggobi instance in which to find the dataset. If \code{.data}
  is supplied as a \code{ggobiDataset}, this is not used. Otherwise, it can be
  a \code{ggobi} object or an integer }
  \item{isError}{a logical value, if TRUE means an error is generated if 
    any of the variables are not found in the GGobi dataset. The purpose
    of this argument is to allow the caller to turn off errors in order to 
    process multiple plots and then report the missing variables for all of them.
    This is often preferrable to reporting the first error and have the user
    solve the problems iteratively.}
}
\value{
 An object of the same class as the input argument \code{desc},
but with the \code{.ggobi} and \code{.data} slots 
substituted with the values given in the call, and
the variable references converted to integers identifying
the variables within the dataset referenced by this object
(in the \code{.data} field).
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{plotLayout}}
\code{\link{scatterplotDescription}}
\code{\link{ashDescription}}
\code{\link{scatmatrixDescription}}
\code{\link{parallelCoordDescription}}
}

\examples{

}
\keyword{visualization}
\keyword{interactive graphics}
