\name{resolveColors.ggobi}
\alias{resolveColors.ggobi}
\title{Map names to color values in a ggobi instance.}
\description{
  This currently does not work but will when color schemes
  are enabled in GGobi.

  Colors in ggobi are represented by entries in a color
  table or matrix as Red, Green and Blue values.
  To set a color, one can identify the entry in that table 
  either by number/index or by name.
  This function maps color names to the corresponding
  index so that these values can be passed to the low-leve
  C routines.  This function is typically called internally.
}
\usage{
resolveColors.ggobi(..., .gobi=getDefaultGGobi())
}
\arguments{
  \item{\dots}{names of colors to be resolved in the default
   color map of the ggobi instance.}
  \item{.gobi}{the ggobi instance whose default color map is to 
   be used to resolve the names.}
}
\value{
 An integer vector specifying the indices of the 
 entries in the color map corresponding to the specified
names.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 \code{\link{getColors.ggobi}}
 \code{\link{setColors.ggobi}}
 \code{\link{getColorMap.ggobi}}
 \code{\link{setColorMap.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"))
\dontrun{
  g$resolveColors("red", "green")
}
}
\keyword{visualization}
\keyword{interactive graphics}
