\name{isValid.ggobi}
\alias{isValid.ggobi}
\title{Determines whether a reference to an internal ggobi object is valid}
\description{
 One can create multiple, independent ggobi instances within a single
R session and one can also remove them either programmatically or
via the GUI.  To be able to refer to these objects which are
actually C-level internal objects, one has a reference or handle
from an S object. Since the C level object can be destroyed
while the S object still refers to them, this function
allows one to check whether the internal object
to which S \code{ggobi} object refers is still in existence.
}
\usage{
isValid.ggobi(.gobi)
}
\arguments{
  \item{.gobi}{an object of class \code{ggobi} which refers to an
    internal ggobi instance.}
}
\value{
 A logical value with \code{TRUE} indicating that
the reference identifies a real object that currently
exists within the ggobi engine, or \code{FALSE}
that the C level object to which the S object refers no longer exists.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
\code{\link{ggobi}}
\code{\link{close.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")

   # still valid
  isValid.ggobi(g)  

  close(g)

   # no longer valid.
  isValid.ggobi(g)  
}
\keyword{visualization}
\keyword{interactive graphics}
