\name{getNumGGobis}
\alias{getNumGGobis}
\title{ The number of ggobi instances within this session}
\description{
 One or more ggobi instances can be created within an R
session so that one can simultaneously look at different datasets 
or have different views of the same dataset.
This function returns the number of ggobis in
existence. This can be used in conjunction
with \code{\link{setDefaultGGobi}} to
soecify which ggobi instance should receive 
commands by default.
}
\usage{
 getNumGGobis()
}
%- maybe also `usage' for other objects documented here.
\details{
 The different ggobi instances are maintained as C 
level structures. This function accesses a variable
that stores how many are in existence when the function
is invoked.
}
\value{
 An integer vector of length 1
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{\code{\link{setDefaultGGobi}},
\code{\link{getDefaultGGobi}},
\code{\link{ggobi}}
}

\examples{
  # Get the total number of ggobi instances
 getNumGGobis()

 # Loop over all the ggobi instances and print
 # their basic characteristics
 for(i in 1:getNumGGobis())
  print(getDescription.ggobi(.gobi = i))


 # Make the last ggobi instance created
 # the default one.
 setDefaultGGobi(getNumGGobis())
}
\keyword{Visualization}
