\name{close.ggobi}
\alias{close.ggobi}
\title{Terminates and discards a ggobi instance}
\description{
  This allows the caller to close a ggobi instance and discard the
resources it uses. The function closes the display windows and
variable panel window associated with this ggobi instance.
It also resets the default ggobi instance to be the last
one created.

\code{close} is a generic function in R that 
applies to objects of class \code{ggobi}, \code{ggobiDisplay} and
\code{ggobiDisplayDescription}.
}
\usage{
close.ggobi(con=getDefaultGGobi(),...)
}
\arguments{
  \item{con}{the object of class \code{ggobi} identifying the specific ggobi instance to be closed.
  This is named \code{con} to be consistent with the generic function.
  }
  \item{...}{ignored and here only for compatability with the associated generic function.}
}
\details{
 If the \code{.gobi} argument is specified, the 
default ggobi (i.e. that returned via \code{\link{getDefaultGGobi}}
is only modified if that object is the default ggobi instance.
}
\value{
 Returns a logical value indicating whether this operation
was successful or not.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{ggobi}}
\code{\link{getGGobi}}
\code{\link{getDefaultGGobi}}
\code{\link{close.ggobiDisplay}}
\code{\link{close.ggobiDisplayDescription}}
}

\examples{
 ggobi(args=c("-verbose", "-xml", system.file("data", "flea.xml", package="Rggobi")))
 close.ggobi()

  #  Open two ggobi instances.

 g1 <- ggobi(args=c("-verbose", "-xml", system.file("data", "flea.xml", package="Rggobi"), args="-noinit"))
 g2 <- ggobi(args=c("-verbose", "-xml", system.file("data", "buckyball.xml", package="Rggobi"), args="-noinit"))

  # Close g1
 close.ggobi(g1)
}
\keyword{visualization}
\keyword{interactive graphics}

