\name{addXMLDataset}
\alias{addXMLDataset}
\title{Serialize dataset to GGobi's XML format.}
\description{
  This writes a dataset in the XML format
  used by GGobi
}
\usage{
addXMLDataset(data, name, dom, description = NULL)
}
\arguments{
  \item{data}{the dataset to be serialized.}
  \item{name}{the name to use for the \code{name} attribute for the dataset}
  \item{dom}{the output object to which to write the XML. This is
    usually an object of class \code{XMLOutputStream}.}
  \item{description}{an optional string or XML node giving a
    human-readable description of the dataset.}
}
\details{
  See \code{\link{writeDataXML}}. 
}
\value{

}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{writeDataXML}}
}

\examples{

 data(mtcars)
 addXMLDataset()
 dd <- XMLOutputBuffer("ggobidata", close = FALSE)
 dd <- addXMLDataset(mtcars, "mtcars", dd, "The mtcars data taken from R")
 cat(dd$value())
}
\keyword{visualization}
\keyword{interactive graphics}
