\name{getRowGroups.ggobi}
\alias{getRowGroups.ggobi}
\alias{setRowGroups.ggobi}
\title{Sets or queries the groupings of observations in a ggobi dataset.}
\description{
 Records/observations in a ggobi dataset can be arranged
into groups rather than treated individually.
Then brushing a point in that group selects
all points in that group.
The groups are assigned by specifying a group
index (integers starting at 1)
for the different records.
These functions allow one to query and set the 
groups. 
}
\usage{
getRowGroups.ggobi(.data=1, .gobi=getDefaultGGobi())
setRowGroups.ggobi(ids, .data=1, .gobi=getDefaultGGobi())
}

\arguments{
  \item{ids}{ an integer vector giving the group identifiers
   for all the observations in the dataset.}
  \item{.data}{the dataset in question. This can be an object of 
   class \code{ggobiDataset}, a name that matches those returned
   from \code{getDatasetNames.ggobi} or an integer giving the
   dataset by index.}
  \item{.gobi}{an identifier for the ggobi instance in which to find
   the dataset. If \code{.data} is an object of class \code{ggobiDataset},
  this is not needed. Otherwise, it should be an object of class \code{ggobi}
   or an integer.}
}
\value{

}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
 \code{\link{setColors.ggobi}}
 \code{\link{getColors.ggobi}}
 \code{\link{setGlyphs.ggobi}}
 \code{\link{getGlyphs.ggobi}}
}

\examples{

}
\keyword{visualization}
\keyword{interactive graphics}
