# Create two functions that share
# the same environment and specifically
# a variable that identifies the currently 
# active GGobi.


init.ggobi <-
function(args)
{
 .Call(.ggobi.symbol("init"), as.character(args), FALSE)
}  

tmp <- (function() {
 n <- NULL

getDefaultGGobi <-
function()
{
 return(n)
}

setCurrentGGobi<-function(which)
{
 if(is.integer(which) || is.numeric(which)) {
   n <<- getGGobi(as.integer(which)[1])[[1]]
 } else
   n <<- which
}

 return(list(getDefaultGGobi, setCurrentGGobi))

})()

getDefaultGGobi <- tmp[[1]]
setDefaultGGobi <- tmp[[2]]
rm(tmp)


.First.lib <-
function(libname, pkgname) {
   library.dynam("Rggobi", pkgname, libname)

   checkStructs.ggobi()

   e <- new.env()
   assign("n", NULL, envir=e)    
   environment(getDefaultGGobi) <<- e
   environment(setDefaultGGobi) <<- e
}
