xmlDataViewer <-
function(fileName = "~/Projects/ggobi/ggobi/data/eies.xml", callback = function(obj, w){ guiShow(obj)})
{
 info <- xmlTreeParse(fileName, handlers = dataDescriptionHandlers())$Data()

 tr <- xmlDataTreeViewer(info, name = fileName, callback = callback)

 sw <- gtkScrolledWindow()
 sw$AddWithViewport(tr)

 win <- gtkWindow()
 win$Add(sw)
 
 win$SetUsize(300, 300)

 list(win = win, tr = tr)
}

xmlDataTreeViewer <-
function(info, name = "", top = gtkTree(), callback = function(obj, w){ guiShow(obj)})
{
  UseMethod("xmlDataTreeViewer")
}  

xmlDataTreeViewer.XMLDataCollectionInfo <-
function(info, name = "", top = gtkTree(), callback = function(obj, w){ guiShow(obj)})  
{
  item <- gtkTreeItem(name)
  top$Append(item)

  tr <- gtkTree()
  for(i in names(info)) {
    it <- gtkTreeItem(i)
    if(!is.null(callback))
      it$AddCallback("select", callback, info[[i]])
    tr$Append(it)    
    tmp <- xmlDataTreeViewer(info[[i]], name = i, callback = callback)
    it$SetSubtree(tmp)
  }

  item$SetSubtree(tr)

  top
}  

xmlDataTreeViewer.DatasetInfo <-
function(info, name = "", top = gtkTree(), callback = function(obj, w){ guiShow(obj)})  
{
  item <- gtkTreeItem("Description")
  item$AddCallback("select", callback, list(info, "description", info))
  top$Append(item)

  item <- gtkTreeItem("Variables")
  top$Append(item)
  tr <- gtkTree()
  for(i in names(info[["variables"]])) {
    it <- gtkTreeItem(i)
    if(!is.null(callback))
      it$AddCallback("select", callback, list(info[[i]], i, info))
    tr$Append(it)
    tmp <- xmlDataTreeViewer(info[["variables"]][[i]], name = i, callback = callback)
    it$SetSubtree(tmp)
  }
  item$SetSubtree(tr)

  top
}  

xmlDataTreeViewer.VariableInfo <-
function(info, name = "", top = gtkTree())  
{
  fields <- getSimpleTreeSlots(info)

  which <- match(fields, names(info))
  for(i in fields[!is.na(which)]) {
    item <- gtkTreeItem(i)
    top$Append(item)

    if(!is.null(callback))
      it$AddCallback("select", callback, list(info[[i]], i, info))    
  }

  top
}

getSimpleTreeSlots <-
function(obj)
{
  UseMethod("getSimpleTreeSlots")
}

getSimpleTreeSlots.VariableInfo <-
function(obj)
{
   c("name", "nickname", "description", "quickHelp")
}

getSimpleTreeSlots.RealVariableInfo <-
function(obj)
{
  names(obj)
}  

getSimpleTreeSlots.CategoricalVariableInfo <-
function(obj)
{
  names(obj)[- match("levels", names(obj))]
}  


xmlDataTreeViewer.CategoricalVariableInfo <-
function(info, name = "", top = gtkTree())
{
  top <- xmlDataTreeViewer.VariableInfo(info, name = name, top = top)
  item <- gtkTreeItem("levels")
  top$Append(item)
  tr <- gtkTree()
  for(i in names(info$levels)) {
     it <- gtkTreeItem(i)
     tr$Append(it)
  }
  item$SetSubtree(tr)

  top
}  
  
guiShow <-
function(obj, container = gtkVBox())
{
 UseMethod("guiShow")
}

guiShow.default <-
function(obj, container = gtkVBox())
{
  NULL
}  

guiShow.VariableInfo <-
function(obj, container = gtkVBox())
{
  slots <- getSimpleTreeSlots(obj)

  for(i in slots) {
    b <- gtkHBox(TRUE, 3)
    label <- gtkLabel(i)
    b$PackStart(label)
    val <- gtkLabel(info[[i]])
    b$PackStart(val)    
    container$PackStart(b)
  }
}  


