
getVariable.ggobi <-
function(which, .data = 1, .gobi = getDefaultGGobi(), asDataFrame = F)
{
  idx <- getVariableIndex.ggobi(which, .data = .data, .gobi = .gobi)
  if(any(is.na(idx))) {
    stop(paste("Unmatched variable name", which[is.na(idx)],"in ggobi"))
  }

  varNames <- getVariableNames.ggobi(.data = .data, .gobi = .gobi)[idx]
  if(asDataFrame)
    rowNames <- getRowNames.ggobi(.data = .data, .gobi = .gobi)

  if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

  vals <- .GGobiCall("getVariables", as.integer(idx), .data, .gobi=.gobi)
  names(vals)  <- varNames

  if(asDataFrame)
    vals <- data.frame(vals, row.names = rowNames, check.names = FALSE)

  vals
}
