.ad l
.nh
.TH STEREO3D 1 "19 May 2003" "Raster3D"
.SH NAME

stereo3d - render a Raster3D scene as a side-by-side stereo pair

.SH SYNOPSIS

   stereo3d [options] [-png  [outfile.png ]] < infile.r3d > outfile.png 
   stereo3d [options]  -tiff [outfile.tiff]  < infile.r3d > outfile.tiff

.PP
\fIstereo3d\fP is a shell script that renders a single Raster3D input 
file as a side-by-side stereo pair. 

stereo3d uses the Raster3D utilities \fIlabel3d\fP,
\fInormal3d\fP and \fIrender\fP, 
and the ImageMagick image processing package. 
Intermediate scratch files are created in directory TMPDIR, if defined,
otherwise in /usr/tmp.

The right eye and left eye views are separately rendered,
optionally given black borders, 
and merged to form a single side-by-side stereo pair.

.PP
The syntax for stereo3d has been changed in version 2.6e to match that 
of render.
Input is from stdin, output is to stdout unless a filename is given
as an argument to the -png or -tiff options.

.PP
.SH EXAMPLES

If the following line would render a single image: 

 	render -tiff single.tiff < input.r3d

then the following line would render the same scene as a 
stereo pair instead: 

 	stereo3d -tiff stereo.tiff < input.r3d

.PP
.SH OPTIONS

.B "-angsep"
.PP
By default the stereo effect is generated by a shear operation.
The \fI-angsep\fP option creates stereo by using angular separation instead.
Neither option is perfect: the default handles shadows badly,
and the -angsep option blurs specular highlights.

.B "-border"
.PP
By default the left and right images are placed next to each other with
no intervening space and no frame around them.  The \fI-border\fP option
requests a 4 pixel wide black border separating and surrounding the 
component images.

.B "-size HHHxVVV"
.PP
Both the left and right eye views are forced to this size in pixels, 
overriding whatever size is given in the header records of the input file.

.SH SOURCE
 
.B web URL:
 	http://www.bmsc.washington.edu/raster3d/raster3d.html
 
.B contact:		
 	Ethan A Merritt
 	University of Washington, Seattle WA 98195
 	merritt@u.washington.edu



.SH SEE ALSO
label3d(l), normal3d(l), render(l), raster3d(l)
.PP
.SH AUTHORS

 Ethan A Merritt.

