/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include "config.h"
#include "qmailadmin.h"
#include "qmailadminx.h"

extern FILE *lang_fs;
extern FILE *color_table;


check_local_user( user )
 char *user;
{
 struct stat buf;
 int i,j;

  strcpy(TmpBuf, ".qmail-");
  for(i=0,j=7;user[i]!=0;++i,++j){
    if ( user[i] == '.' ) TmpBuf[j] = ':'; 
    else TmpBuf[j] = user[i];
  }
  TmpBuf[j] = 0;

  if ( stat(TmpBuf, &buf) == 0 ) return(-1);
  if ( vauth_getpw(user, Domain)) return(-1);

  return(0);
}

show_counts()
{
  count_users();
  count_aliases();
  count_forwards();
  count_autoresponders();
  count_mailinglists();

  fprintf(actout, "Pop accounts   = %d<BR>\n", CurPopAccounts);
  fprintf(actout, "Aliases        = %d<BR>\n", CurAliases);
  fprintf(actout, "Forwards       = %d<BR>\n", CurForwards);
  fprintf(actout, "Autoresponders = %d<BR>\n", CurAutoResponders);
  fprintf(actout, "Mailing lists  = %d<BR>\n", CurMailingLists);

}

check_email_addr( addr )
 char *addr;
{
 char *taddr = addr;


  if(strlen(taddr)<0) return(1);
  for(taddr=addr;*taddr!=0;++taddr) {
    if(!isalnum(*taddr) && !ispunct(*taddr)) {
      return(1);
    }
  }

  /* force to lower */
  lowerit(addr);

  for(taddr=addr;*taddr!='@'&&*taddr!=0;++taddr) {
    if ( isspace(*taddr) ) return(1);
    if(ispunct(*taddr) && 
       *taddr!='.' && *taddr!='-' && *taddr!='+' && *taddr!='=' &&
       *taddr!='_') {
      return(1);
    }
  }

  /* if just a user name with no @domain.com then bad */
  if (*taddr==0) return(1);

  /* Look for a sub domain */
  for(;*taddr!='.'&&*taddr!=0;++taddr);

  if (*taddr==0) return(1);
  return(0);
}

fixup_local_name( addr )
 char *addr;
{
 char *taddr = addr;

  /* don't allow zero length user names */
  if(strlen(taddr)<=0) return(1);

  /* force it to lower case */
  lowerit(addr);

  /* check for valid email address */
  for(taddr=addr;*taddr!=0;++taddr) {

    if(!isalnum(*taddr) && !ispunct(*taddr)) return(1);
    if(isspace(*taddr)) return(1);

    if(ispunct(*taddr)&&*taddr!='-'&&*taddr!='.'&&*taddr!='_' &&
               *taddr!='+' && *taddr!='=') {
      if(*taddr!='.') return(1);
    }
  }

  /* if we made it here, everything is okay */
  return(0);
}

ack(msg, c)
 char *msg;
 int c;
{
  fprintf(actout,"%s\n", msg);
  fprintf(actout,"</BODY></HTML>\n", msg);
  vclose();
  exit(0);
}

upperit( instr )
 char *instr;
{
  while(*instr!=0) {
    if ( islower(*instr) ) *instr = toupper(*instr);
    ++instr;
  }
}

char *safe_getenv(char *var)
{
 char *s;

  s = getenv(var);
  if ( s == NULL ) return("");
  return(s);
}

char *strstart(sstr, tstr)
 char *sstr;
 char *tstr;
{
 char *ret_str;

  ret_str = sstr;
  if ( sstr == NULL || tstr == NULL ) return(NULL);

  while ( *sstr != 0 && *tstr != 0 ) {
    if ( *sstr != *tstr ) return(NULL);
    ++sstr;
    ++tstr;
  }

  if ( *tstr == 0 ) return(ret_str);
  return(NULL);

}

int open_lang( char *lang)
{
 char tmpbuf[200];
 char *tmpstr;
 struct stat mystat;

  /* do not read lang files with path control characters */
  if ( strstr(lang,".")!=NULL || strstr(lang,"/")!=NULL ) return(-1);

  if ( lang_fs == NULL ) {
    tmpstr = getenv(QMAILADMIN_TEMPLATEDIR);
    if (tmpstr == NULL ) tmpstr = HTMLLIBDIR;

    snprintf(tmpbuf, 200, "%s/%s", tmpstr, lang);

    /* do not open symbolic links */ 
    if (lstat(tmpbuf, &mystat)==-1 || S_ISLNK(mystat.st_mode)) return(-1);

    if ( (lang_fs=fopen(tmpbuf, "r"))==NULL) return(-1);
  }
  return(0);
}

char *get_html_text( char *index )
{
 char *tmpbuf;
 char *tmpstr;

  tmpbuf = malloc(400);

  if (lang_fs == NULL) return("");

  rewind(lang_fs);
  while(fgets(tmpbuf,400,lang_fs)!=NULL){
    tmpstr = strtok(tmpbuf, " ");
    if (strcmp(tmpstr, index) == 0 ) {
      tmpstr = strtok(NULL, "\n");
      return(tmpstr);
    }    
  }
  return("");
}

int open_colortable()
{
 char tmpbuf[200];
 char *tmpstr;

  tmpstr = getenv(QMAILADMIN_TEMPLATEDIR);
  if (tmpstr == NULL ) tmpstr = HTMLLIBDIR;

  snprintf(tmpbuf, 200, "%s/colortable", tmpstr);
  if ( (color_table=fopen(tmpbuf, "r"))==NULL) return(-1);
  return(0);
}

char *get_color_text( char *index )
{
 char *tmpbuf;
 char *tmpstr;

  tmpbuf = malloc(400);

  if (color_table == NULL) return("");

  rewind(color_table);
  while(fgets(tmpbuf,400,color_table)!=NULL){
    tmpstr = strtok(tmpbuf, " ");
    if (strcmp(tmpstr, index) == 0 ) {
      tmpstr = strtok(NULL, "\n");
      return(tmpstr);
    }    
  }
  return("");
}
