/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include <vpopmail.h>
#include <vauth.h>
#include "qmailadmin.h"
#include "qmailadminx.h"
#include <vpopmail_config.h>



process_commands()
{
  int pid;

  if ( strncmp(TmpBuf2,"showmenu", MAX_BUFF) == 0 ) {
    show_menu(Username, Domain, Mytime);

  } else if (strncmp(TmpBuf2, "showusers", MAX_BUFF) == 0) {
    GetValue(TmpCGI,Pagenumber, "page=",MAX_BUFF);
    GetValue(TmpCGI,SearchUser, "searchuser=",MAX_BUFF);
    show_users(Username, Domain, Mytime, TmpBuf2);

  } else if (strncmp(TmpBuf2, "showaliases", MAX_BUFF) == 0) {
    GetValue(TmpCGI,Pagenumber, "page=",MAX_BUFF);
    show_aliases(Username, Domain, Mytime, TmpBuf2);

  } else if (strncmp(TmpBuf2, "showforwards", MAX_BUFF) == 0) {
    GetValue(TmpCGI,Pagenumber, "page=",MAX_BUFF);
    show_forwards(Username, Domain, Mytime, TmpBuf2);

  } else if (strncmp(TmpBuf2, "showmailinglists", MAX_BUFF) == 0) {
    show_mailing_lists(Username, Domain, Mytime, TmpBuf2);

  } else if (strncmp(TmpBuf2, "showautoresponders", MAX_BUFF) == 0) {
    show_autoresponders(Username, Domain, Mytime, TmpBuf2);

  } else if ( strncmp(TmpBuf2,"adduser", MAX_BUFF) == 0 ) {
    adduser();

  } else if ( strncmp(TmpBuf2,"addusernow", MAX_BUFF) == 0 ) {
    addusernow();

  } else if ( strncmp(TmpBuf2,"bounceall", MAX_BUFF) == 0 ) {
    bounceall();

  } else if ( strncmp(TmpBuf2,"deleteall", MAX_BUFF) == 0 ) {
    deleteall();

  } else if ( strncmp(TmpBuf2,"setremotecatchall", MAX_BUFF) == 0 ) {
    setremotecatchall();

  } else if ( strncmp(TmpBuf2,"setremotecatchallnow", MAX_BUFF) == 0 ) {
    setremotecatchallnow();

  } else if ( strncmp(TmpBuf2,"addlistmodnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    addlistmodnow();

  } else if ( strncmp(TmpBuf2,"dellistmod", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    dellistmod();

  } else if ( strncmp(TmpBuf2,"dellistmodnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    dellistmodnow();

  } else if ( strncmp(TmpBuf2,"addlistmod", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    addlistmod();

  } else if ( strncmp(TmpBuf2,"showlistmod", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    show_list_moderators();

  } else if ( strncmp(TmpBuf2,"addlistdig", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    addlistdig();

  } else if ( strncmp(TmpBuf2,"addlistdignow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    addlistdignow();

  } else if ( strncmp(TmpBuf2,"dellistdig", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    dellistdig();

  } else if ( strncmp(TmpBuf2,"dellistdignow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    dellistdignow();

  } else if ( strncmp(TmpBuf2,"showlistdig", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    show_list_digest_users();

  } else if ( strncmp(TmpBuf2,"moduser", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "moduser=",MAX_BUFF);
    moduser();

  } else if ( strncmp(TmpBuf2,"modusernow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Password1, "password1=",MAX_BUFF);
    GetValue(TmpCGI,Password2, "password2=",MAX_BUFF);
    GetValue(TmpCGI,Gecos, "gecos=",MAX_BUFF);
    modusergo();

  } else if ( strncmp(TmpBuf2,"deluser", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "deluser=",MAX_BUFF);
    deluser();

  } else if ( strncmp(TmpBuf2,"delusernow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "deluser=",MAX_BUFF);
    delusergo();

  } else if ( strncmp(TmpBuf2,"moddotqmail", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    moddotqmail();

  } else if ( strncmp(TmpBuf2,"moddotqmailnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    GetValue(TmpCGI,LineData, "linedata=",MAX_BUFF);
    GetValue(TmpCGI,Action, "action=",MAX_BUFF);
    moddotqmailnow();

  } else if ( strncmp(TmpBuf2,"deldotqmail", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    deldotqmail();

  } else if ( strncmp(TmpBuf2,"deldotqmailnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    deldotqmailnow();

  } else if ( strncmp(TmpBuf2,"adddotqmail", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    adddotqmail();

  } else if ( strncmp(TmpBuf2,"adddotqmailnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "newu=",MAX_BUFF);
    GetValue(TmpCGI,Alias, "alias=",MAX_BUFF);
    GetValue(TmpCGI,AliasType, "atype=",MAX_BUFF);
    adddotqmailnow();

  } else if ( strncmp(TmpBuf2,"addmailinglist", MAX_BUFF) == 0 ) {
    addmailinglist();

  } else if ( strncmp(TmpBuf2,"delmailinglist", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    delmailinglist();

  } else if ( strncmp(TmpBuf2,"delmailinglistnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    delmailinglistnow();

  } else if ( strncmp(TmpBuf2,"addlistusernow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    addlistusernow();

  } else if ( strncmp(TmpBuf2,"dellistuser", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    dellistuser();

  } else if ( strncmp(TmpBuf2,"dellistusernow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    GetValue(TmpCGI,Newu, "newu=",MAX_BUFF);
    dellistusernow();

  } else if ( strncmp(TmpBuf2,"addlistuser", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    addlistuser();

  } else if ( strncmp(TmpBuf2,"addmailinglistnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "newu=",MAX_BUFF);
    addmailinglistnow();

  } else if ( strncmp(TmpBuf2,"modmailinglist", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    modmailinglist();

  } else if ( strncmp(TmpBuf2,"modmailinglistnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "newu=",MAX_BUFF);
    modmailinglistnow();

  } else if ( strncmp(TmpBuf2,"modautorespond", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    modautorespond();

  } else if ( strncmp(TmpBuf2,"addautorespond", MAX_BUFF) == 0 ) {
    addautorespond();

  } else if ( strncmp(TmpBuf2,"addautorespondnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "newu=",MAX_BUFF);
    GetValue(TmpCGI,Alias, "alias=",MAX_BUFF);
    GetValue(TmpCGI,Message, "message=",MAX_BIG_BUFF);
    GetValue(TmpCGI,Newu, "owner=",MAX_BUFF);
    addautorespondnow();

  } else if ( strncmp(TmpBuf2,"modautorespondnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "newu=",MAX_BUFF);
    GetValue(TmpCGI,Alias, "alias=",MAX_BUFF);
    GetValue(TmpCGI,Message, "message=",MAX_BIG_BUFF);
    GetValue(TmpCGI,Newu, "owner=",MAX_BUFF);
    modautorespondnow();

  } else if ( strncmp(TmpBuf2,"showlistusers", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    show_list_users();

  } else if ( strncmp(TmpBuf2,"setdefault", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "deluser=",MAX_BUFF);
    GetValue(TmpCGI,Pagenumber, "page=",MAX_BUFF);
    setdefaultaccount();

  } else if ( strncmp(TmpBuf2,"delautorespond", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    delautorespond();

  } else if ( strncmp(TmpBuf2,"delautorespondnow", MAX_BUFF) == 0 ) {
    GetValue(TmpCGI,ActionUser, "modu=",MAX_BUFF);
    delautorespondnow();

  } else if ( strncmp(TmpBuf2,"logout", MAX_BUFF) == 0 ) {
    sprintf(TmpBuf, "%s/%s/Maildir", RealDir, Username );
    del_id_files(TmpBuf);
    show_login();

  } else if ( strncmp(TmpBuf2,"showcounts", MAX_BUFF) == 0 ) {
    show_counts();
  }

  vclose();
  exit(0);
}

setdefaultaccount()
{
 struct vqpasswd *pw;
 FILE *fs;
 int i;
 int j;

  if ( (fs = fopen(".qmail-default", "w")) == NULL ) {
    sprintf(StatusMessage,"%s", get_html_text("082"));
  } else {
    if ((pw = vauth_getpw( ActionUser, Domain )) == NULL) {
      sprintf(StatusMessage,"%s $s@%s", get_html_text("223"),ActionUser,Domain);
    } else {
      fprintf(fs, "| %s/bin/vdelivermail '' %s\n", VPOPMAILDIR, pw->pw_dir);
    }
    fclose(fs);
  }
  show_users(Username, Domain, Mytime);
    vclose();
  exit(0);
}
