/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include <dirent.h>
#include <vpopmail.h>
#include <vauth.h>
#include "config.h"
#include "qmailadmin.h"
#include "qmailadminx.h"

char* dotqmail_alias_command(char* command);

int show_aliases(void)
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage, "%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template("show_alias.html");
  return 0;
}


show_dotqmail_lines(char *user, char *dom, time_t mytime, char *dir)
{
 DIR *mydir;
 struct dirent *mydirent;
 FILE *fs;
 char alias_user[MAX_FILE_NAME];
 char alias_name[MAX_FILE_NAME];
 char *alias_name_from_command;
 int i,j,stop,k,startnumber;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  if (atoi(Pagenumber)==0) {
    *Pagenumber='1';
  }

  startnumber = MAXALIASESPERPAGE * (atoi(Pagenumber) - 1);
  k=0;

  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"<tr><td colspan=\"4\">");
    fprintf(actout,"%s %d", get_html_text("143"), 1);
    fprintf(actout,"</td></tr>");
    return(0);
  }

  while ((mydirent=readdir(mydir)) != NULL) {
    /*
     *  don't read files that are really ezmlm-idx listowners,
     *  i.e. .qmail-user-owner
     *   
     */ 
    if ( strncmp(".qmail-", mydirent->d_name, 7) == 0 ) {
      if ( strstr(mydirent->d_name, "-owner") != NULL ) continue; 
      if ( strstr(mydirent->d_name, "-default") != NULL ) continue; 

      if ( k < startnumber ) {
        k++; 
        continue;
      }
      if ( k >MAXALIASESPERPAGE + startnumber) {
        break;
      }

      if ( (fs=fopen(mydirent->d_name,"r"))==NULL) {
        fprintf(actout,"<tr><td colspan=\"4\">");
        fprintf(actout,"%s %s", get_html_text("144"), mydirent->d_name);
        fprintf(actout,"</td></tr>\n");
        fclose(fs);
        continue;
      }
      memset(TmpBuf2,0,MAX_BUFF);
      fgets( TmpBuf2, MAX_BUFF, fs);
      alias_name_from_command = dotqmail_alias_command(TmpBuf2);
      if ( alias_name_from_command != NULL ) {
                          
        /* first case checks if the file beginnning is an email
         * and the function is not being called to display forwards,
         * the second case checks if the file beginning is an user, and
         * the type is not an alias 
         */
                            
        for(i=7,j=0;j<MAX_FILE_NAME-1&&mydirent->d_name[i]!=0;++i,++j) {
          alias_name[j] = mydirent->d_name[i];
          if ( alias_name[j] == ':' ) alias_name[j] = '.';
        }
        alias_name[j] = 0;
        stop=0;

        fprintf(actout, "<tr>\n");
        fprintf(actout, "<td align=\"left\">%s</td>\n", alias_name);
        fprintf(actout, "<td align=\"left\">");
        while (!stop) {
          alias_name_from_command = dotqmail_alias_command(TmpBuf2);
                
          /* check to see if it is an invalid line , 
           * if so skip to next
           */
          if (alias_name_from_command == NULL ) {
            if (fgets(TmpBuf2, 500, fs)==NULL) { 
              stop=1;
            }
            continue;
          }
                    
          strcpy(alias_user, alias_name_from_command);
                
          if (fgets(TmpBuf2, 500, fs) == NULL) {
            stop=1;
            fprintf(actout, "%s ", alias_user);
          } else {
            fprintf(actout, "%s, ", alias_user);
          }
        }
        fprintf(actout, "</td>\n");
                
        fprintf(actout, "<td align=\"center\">");
        fprintf(actout, "<a href=\"%s/com/moddotqmail?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,alias_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=\"0\"></a>");
        fprintf(actout, "</td>\n");
        fprintf(actout, "<td align=\"center\">");
        fprintf(actout, "<a href=\"%s/com/deldotqmail?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,alias_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=\"0\"></a>");
        fprintf(actout, "</td>\n");
        fprintf(actout, "</tr>\n");
      }
      fclose(fs);
      k++;
    }
  }
    
  closedir(mydir);

  if (AdminType == DOMAIN_ADMIN) {
    fprintf(actout, "<tr><td align=\"right\" colspan=\"4\">");
    fprintf(actout, "[&nbsp;");
    if(atoi(Pagenumber) > 1 ) {
      fprintf(actout, "<a href=\"%s/com/showforwards?user=%s&dom=%s&time=%d&page=%d\">%s</a>",
        CGIPATH,user,dom,mytime,atoi(Pagenumber)-1?atoi(Pagenumber)-1:atoi(Pagenumber),get_html_text("135"));
      fprintf(actout, "&nbsp;|&nbsp;");
    }
    fprintf(actout, "<a href=\"%s/com/showforwards?user=%s&dom=%s&time=%d&page=%s\">%s</a>",
      CGIPATH,user,dom,mytime,Pagenumber,get_html_text("136"));
    fprintf(actout, "&nbsp;|&nbsp;");
    fprintf(actout, "<a href=\"%s/com/showforwards?user=%s&dom=%s&time=%d&page=%d\">%s</a>",
      CGIPATH,user,dom,mytime,atoi(Pagenumber)+1,get_html_text("137"));    
    fprintf(actout, "&nbsp;]");
    fprintf(actout, "</td></tr>");                                    
  }
}

/* 
 * This Function shows the inside of a .qmail file, 
 * with the edit mode
 *
 */
int show_dotqmail_file(char *user) 
{
 FILE *fs;
 char alias_user[MAX_FILE_NAME];
 char *alias_name_from_command;
 char *dot_file;
 int l,j;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
    
  l = strlen(user);
  dot_file= strcat(strcpy(malloc(8 + l), ".qmail-"), user);

  for(j=8;dot_file[j]!=0;j++) {
    if (dot_file[j]=='.') {
      dot_file[j] = ':';
    }
  }

  if ( (fs=fopen(dot_file,"r"))==NULL) {
    sprintf(StatusMessage,"%s %s<br>\n", get_html_text("144"), dot_file);
    vclose();
    exit(0);
  }
                
  fprintf(actout, "<tr>");
  fprintf(actout, "<td align=\"center\"><b>%s</b></td>", user);
  fprintf(actout, "<td align=\"left\">&nbsp;</td>");
  fprintf(actout, "<td align=\"left\">&nbsp;</td>");
  fprintf(actout, "</tr>");
    
  memset(TmpBuf2, 0, MAX_BUFF);

  while (fgets( TmpBuf2, MAX_BUFF, fs) != NULL) {
    alias_name_from_command = dotqmail_alias_command(TmpBuf2);
                        
    /* check to see if it is an invalid line , if so skip to next*/
    if (alias_name_from_command == NULL ) continue;

    strcpy(alias_user, alias_name_from_command);
                
    fprintf(actout, "<tr>\n");
    fprintf(actout, "<td align=\"left\">&nbsp;</td>\n");
    fprintf(actout, "<td align=\"center\">%s</td>\n", alias_user);
    fprintf(actout, "<td align=\"center\">\n");
    fprintf(actout, "<form method=\"post\" name=\"moddotqmail\" action=\"%s/com/moddotqmailnow\">\n", CGIPATH);
    fprintf(actout, "<input type=\"hidden\" name=\"user\" value=\"%s\">\n", 
      Username);
    fprintf(actout, "<input type=\"hidden\" name=\"dom\" value=\"%s\">\n", 
      Domain);
    fprintf(actout, "<input type=\"hidden\" name=\"time\" value=\"%i\">\n", 
      Mytime);
    fprintf(actout, "<input type=\"hidden\" name=\"modu\" value=\"%s\">\n", 
      user);
    fprintf(actout, "<input type=\"hidden\" name=\"linedata\" value=\"%s\">\n",
      TmpBuf2);
    fprintf(actout, "<input type=\"hidden\" name=\"action\" value=\"delentry\">\n");
    fprintf(actout, "<input type=\"image\" border=\"0\" src=\"/images/qmailadmin/delete.png\">\n");
    fprintf(actout, "</form>\n");
    fprintf(actout, "</td>\n");
    fprintf(actout, "</tr>\n");
  }
  fclose(fs);
}

int onevalidonly(char *user) {
 FILE *fs;
 char *alias_name_from_command;
 char *dot_file;
 int l,j;

  l = strlen(user);
  dot_file= strcat(strcpy(malloc(8 + l), ".qmail-"), user);
  for(j=8;dot_file[j]!=0;j++) {
    if (dot_file[j]=='.') {
      dot_file[j] = ':';
    }
  }

  if ( (fs=fopen(dot_file,"r"))==NULL) {
    sprintf(StatusMessage,"%s %s<br>\n", get_html_text("144"),
    dot_file);
    vclose();
    exit(0);
  }
            
  j=0;
  while( fgets( TmpBuf2, MAX_BUFF, fs) != NULL ) {
    alias_name_from_command = dotqmail_alias_command(TmpBuf2);
    /* check to see if it is an invalid line , if so skip to next */
    if (alias_name_from_command == NULL ) continue;
        
    j++;
  }
  fclose(fs);

  if (j <2 ) return (1);
  else return (0);

}



moddotqmail()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template("mod_dotqmail.html");
}

moddotqmailnow() 
{
 struct vqpasswd *pw;

  if ( strcmp(ActionUser,"default")==0) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  if (strcmp(Action,"delentry")==0) {
    if (onevalidonly(ActionUser) ) {
      sprintf(StatusMessage, "%s\n", get_html_text("149"));
      moddotqmail();
      vclose();
      exit(0);
    }
        
    if (dotqmail_del_line(ActionUser,LineData) ) {
      sprintf(StatusMessage, "%s %d\n", get_html_text("150"), 1);
      moddotqmail();
      vclose();
      exit(0);
    }
    sprintf(StatusMessage, "%s\n", get_html_text("151") );
    moddotqmail();
    vclose();
    exit(0);
    
  } else if (strcmp(Action,"addremote")==0) {
    if (check_email_addr(Newu) ) {
      sprintf(StatusMessage, "%s %s\n", get_html_text("148"), Newu);
      moddotqmail();
      vclose();
      exit(0);
    }
    sprintf(TmpBuf2, "&%s\n",Newu);
    
    if (dotqmail_add_line(ActionUser,TmpBuf2)) {
      sprintf(StatusMessage, "%s %d\n", get_html_text("150"), 2);
      moddotqmail();
      vclose();
      exit(0);
    }
    sprintf(StatusMessage,"%s %s\n", get_html_text("152"), Newu);
    moddotqmail();
    vclose();
    exit(0);
    
  } else if (strcmp(Action,"addlocal")==0) {
    if ( !vauth_getpw(Newu, Domain) ) {
      sprintf(StatusMessage, "%s %s\n", Newu, get_html_text("153"));
      moddotqmail();
      vclose();
      exit(0);
    }
    pw = vauth_getpw( Newu, Domain );        
    sprintf(TmpBuf2, "%s/Maildir/\n",pw->pw_dir);
                                                                    
    if (dotqmail_add_line(ActionUser,TmpBuf2)) {
      sprintf(StatusMessage, "%s %d\n", get_html_text("150"), 3);
      moddotqmail();
      vclose();
      exit(0);
    }
    sprintf(StatusMessage, "%s %s\n", Newu, get_html_text("154"));
    moddotqmail();
    vclose();
    exit(0);
  } else {
    sprintf(StatusMessage, "%s\n", get_html_text("155"));
    vclose();
    exit(0);
  }
}

adddotqmail()
{

  if (!(strcmp(AliasType, "alias"))) {
    count_aliases();
    load_limits();
    if ( MaxAliases != -1 && CurAliases >= MaxAliases ) {
      sprintf(StatusMessage, "%s %d\n",  
      get_html_text("156"), MaxAliases);
      show_menu();
      vclose();
      exit(0);
    }
    send_template( "add_alias.html" );

  } else if (!(strcmp(AliasType, "forward"))) {
    count_forwards();
    load_limits();
    if ( MaxForwards != -1 && CurForwards >= MaxForwards ) {
      sprintf(StatusMessage, "%s %d\n", 
      get_html_text("157"), MaxForwards);
      show_menu();
      vclose();
      exit(0);
    }
    send_template( "add_forward.html" );

  } else {    
    fprintf(actout, "%s\n", get_html_text("159"));
    show_menu();
    vclose();
    exit(0);
  }
}


adddotqmailnow()
{
 struct vqpasswd *pw;
 int err;

  if (AdminType!=DOMAIN_ADMIN && 
      !(AdminType==USER_ADMIN && strcmp(ActionUser, Username)==0)) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  if (!(strcmp(AliasType, "alias"))) {
    count_aliases();
    load_limits();
    if ( MaxAliases != -1 && CurAliases >= MaxAliases ) {
      sprintf(StatusMessage, "%s %d\n", get_html_text("156"), MaxAliases);
      send_template( "add_alias.html" );
      vclose();
      exit(0);
    }

  } else if (!(strcmp(AliasType, "forward"))) {
    count_forwards();
    load_limits();
    if ( MaxForwards != -1 && CurForwards >= MaxForwards ) {
      sprintf(StatusMessage, "%s %d\n", get_html_text("157"), MaxForwards);
      send_template( "add_forward.html" );
      vclose();
      exit(0);
    }
  }

  err = 0;

  /* check to see if we already have a user with this name */
  if (err = fixup_local_name(Alias)) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("160"), Alias);
  }

  if (!(strcmp(AliasType, "alias")) && !err ) {
    if (!err && (err = (vauth_getpw( ActionUser, Domain ) == NULL)))
      sprintf(StatusMessage, "%s\n", get_html_text("161"));

  } else if (!(strcmp(AliasType, "forward")) && !err) {

    if (err = ( check_email_addr(ActionUser)) ) {
      sprintf(StatusMessage, "%s %s\n", get_html_text("162"), ActionUser);

    } else if ( err = (strlen(Alias)<=0) ) {
      sprintf(StatusMessage, "%s %s\n", get_html_text("163"), Alias);

    } else if (err = ( fixup_local_name(Alias)) ) {
      sprintf(StatusMessage, "%s %s\n", get_html_text("163"), Alias);
    }

  } else if (!err) {
    err=1;
    sprintf(StatusMessage, "%s\n", get_html_text("164")); 
  }

  if (err) {
    adddotqmail();
    vclose();
    exit(0);
  }

  if (!err) {
    if  (!(strcmp(AliasType, "alias"))) {
      pw = vauth_getpw( ActionUser, Domain );
      sprintf(TmpBuf2, "%s/Maildir/\n", pw->pw_dir);
      dotqmail_add_line(Alias, TmpBuf2);
    } else if  (!(strcmp(AliasType, "forward"))) {
      sprintf(TmpBuf2, "&%s\n", ActionUser);
      dotqmail_add_line(Alias, TmpBuf2);
    } else { 
      err=1; 
    }
  }

  if (err) {
    sprintf(StatusMessage, "%s %s %s %s\n", get_html_text("165"), 
      AliasType, Alias, ActionUser);
  } else {
    sprintf(StatusMessage, "%s %s %s %s\n", get_html_text("166"), 
      AliasType, Alias, ActionUser);
  }
  show_forwards(Username,Domain,Mytime,RealDir);

}

deldotqmail()
{

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template( "del_forward_confirm.html" );

}

deldotqmailnow()
{

  if (AdminType!=DOMAIN_ADMIN && 
       !(AdminType==USER_ADMIN && !strcmp(ActionUser, Username))) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    show_menu(Username, Domain, Mytime);
    vclose();
    exit(0);
  }


  /* check to see if we already have a user with this name */
  if (fixup_local_name(ActionUser)) {
    sprintf(StatusMessage,"%s %s\n", get_html_text("160"), Alias);
    deldotqmail();
    vclose();
    exit(0);
  }

  if (!(dotqmail_delete_files(ActionUser))) {
    sprintf(StatusMessage, "%s %s %s\n", get_html_text("167"), 
      Alias, ActionUser);
  } else {
    sprintf(StatusMessage, "%s %s %s\n", get_html_text("168"), 
      Alias, ActionUser);
  }

  /* don't display aliases/forwards if we just deleted the last one */
  count_aliases();
  count_forwards();
  if((CurForwards + CurAliases) == 0) {
    show_menu(Username, Domain, Mytime);
  } else {
    show_forwards(Username,Domain,Mytime,RealDir);
  }
}

count_aliases()
{
 DIR *mydir;
 struct dirent *mydirent;
 FILE *fs;
 char *alias_name_from_command;

  /* FIXME: Do some caching here. */

  CurAliases = 0;
  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"%s %s<br>\n", get_html_text("144"), "1");
    fprintf(actout, "</table>");
    return(0);
  }


  while( (mydirent=readdir(mydir)) != NULL ) {

    /*
     *  don't read files that are really ezmlm-idx listowners,
     *  i.e. .qmail-user-owner
     */ 
    if ( strncmp(".qmail-", mydirent->d_name, 7) == 0 && 
         ( strstr(mydirent->d_name, ".qmail-owner") != NULL || 
           strstr(mydirent->d_name, "-list-owner") == NULL )) {

      if ( (fs=fopen(mydirent->d_name,"r"))==NULL) {
        fprintf(actout,"%s %s<br>\n", get_html_text("144"), mydirent->d_name);
        continue;
      }
      memset(TmpBuf2,0,MAX_BUFF);
      fgets( TmpBuf2, 500, fs);
      alias_name_from_command = dotqmail_alias_command(TmpBuf2);
      if ( alias_name_from_command != NULL ) {
        if (strstr(alias_name_from_command,"@")==NULL) {
          ++CurAliases;
        }
      }
      fclose(fs);
    }
  }
  closedir(mydir);
}


char* dotqmail_alias_command(char* command)
{
 int len;
 static char user[501];
 char* s;

  if (command == NULL) return NULL;

  /* find the first space and stop the command there */
  len=0;
  while( command[len]!=0 && isspace(command[len])==0 ) ++len;
  command[len] = 0;

    
  /* If it ends with a slash and starts with a / or . then
   * this is a Maildir delivery, local alias
   */
  if( (command[len - 1]=='/') && (command[0] =='/') || (command[0] =='.') ) { 
    strcpy(user, command); user[len - 1] = '\0';

    if ((s = strrchr(user, '/')) == NULL) return NULL;
    if (strcmp(s, "/Maildir") != 0) return NULL;

    *s = '\0';
    if ((s = strrchr(user, '/')) == NULL) return NULL;

    return (s+1);
        
  /* if it's an email address then display the forward */
  } else if ( !check_email_addr( (command+1) ) ){
    strcpy(user, command); 
    s = user;    
    *s = '\0';

    if (command[0] == '&' ) return (s+1);
    else return (command);

  /* if it is a program then */
  } else if ( command[0] == '|' ) {

    /* do not display ezmlm programs */
    if ( strstr(command, "ezmlm" ) != 0 ) return(NULL);

    /* do not display autorespond programs */
    if ( strstr(command, "autorespond" ) != 0 ) return(NULL);

    /* otherwise, display the program */
    return(command);

  } else {

    /* otherwise just report nothing */
    return(NULL);
  }
}
