/****************************************************************************
** ListViewItemMedia class to display the Video sources name, and thumbnail
**
**   Created : Thu Nov 25 12:09:08 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class re-implements the QListViewItem class and adds 
** 1) a thumbnail preview of the video(s)
** 2) a tree-node with a list of all included SourceFileInfo's
****************************************************************************/

#ifndef LISTVIEWITEMMEDIA_H
#define LISTVIEWITEMMEDIA_H


#include <qpixmap.h>
#include <qlistview.h>

#include "cachethumbs.h"

class ListViewItemMedia;
class SourceFileEntry;
class SourceFileInfo;
class CXmlSlideshow;
class QTimer;

class AnimateMini : public QObject
{
  Q_OBJECT
  // This class is coupled with the CacheThumbs class
  // and will animate the thumbnail in the VideoList
public:
           AnimateMini ( ListViewItemMedia * );
  virtual ~AnimateMini ( );

  void initMe ( Cache::Thumbs::Entry * );
  void initMe ( CXmlSlideshow * );
  void refreshButtonState ( );
  void setProgress  ( float );
  void reset  ( );
  void clear  ( );
  void start  ( );
  void stop   ( );
  void info   ( );

protected slots:
  virtual void slotAnimate ( );

private:
  QTimer   *m_pTimerThumbing;
  QPixmap **m_arrayPix;
  QPixmap   m_pixmapOrig;
  int       m_iNumberOfPix;
  int       m_iCurrentPix;
  float     m_fProgress; // If a slideshow is in the makings.
  ListViewItemMedia *m_pItem;
};

class ListViewItemMedia : public QListViewItem
{
	enum enButtonState {StateUndef = 0, StateStop, StatePlay, StateBack};
public:
	ListViewItemMedia ( QListView     *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListViewItem *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListView     *, QListViewItem   *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListViewItem *, SourceFileInfo  *, const QColor &, QString, QSize );
	virtual ~ListViewItemMedia       ( );

	SourceFileEntry *sourceFileEntry ( );
	SourceFileInfo  *sourceFileInfo  ( );
	// Overloaded function
	virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int );
	QColor backgroundColor ( );
	void   replaceInfo     ( SourceFileInfo * );
	void   updateItem      ( );
	void   nextThumb       ( );
	void   itemClicked     ( QPoint & );
	void   setProgress     ( float );

private:
	void initMe ( SourceFileEntry *, const QColor & );	void attachButtons ( QImage *, QPixmap * );
	QPixmap &attachButtons ( QImage &, QSize );
	void miniButton        ( int,  QString & );
	void miniButton        ( int,  CXmlSlideshow * );
	void renderProgress    ( QPixmap *, float );
	void drawButtonState   ( QPixmap * );

private:
	uint m_iButtonState;
	uint m_iPreviousButtonState;
	AnimateMini *m_pAnimateMini;
	QPixmap     *m_pPixmap; // Used if we want to display progress in a Thumbnail

	QColor m_backgroundColor;
	QSize  m_sizeThumbnails;
	// Only one of the two possible data is valid
	SourceFileEntry *m_pSourceFileEntry;
	SourceFileInfo  *m_pSourceFileInfo;

	friend class AnimateMini;
};

#endif // LISTVIEWITEMMEDIA_H
