/****************************************************************************
** Interface to the GUI.
**
**   Created : Mon May 20 22:48:00 2005
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
****************************************************************************/

#ifndef DIALOGREGION_H
#define DIALOGREGION_H

#include <qlabel.h>
#include <qimage.h>

// the designer created GUI.
#include "uidialogregion.h"

class DialogRegion;

class RegionPreview : public QLabel
{
  Q_OBJECT
public:
           RegionPreview ( DialogRegion *, QWidget * );
  virtual ~RegionPreview ( );

protected slots:
  virtual void mouseMoveEvent  ( QMouseEvent * );
  virtual void mousePressEvent ( QMouseEvent * );

private:
  DialogRegion *m_pDialog;
};

class DialogRegion : public uiDialogRegion
{
  Q_OBJECT
public:

           DialogRegion ( QWidget *parent, int );
  virtual ~DialogRegion ( );
  int regionalZone ( );

  void mouseMove  ( const QPoint & );
  void mouseClick ( const QPoint & );

protected slots:
  virtual void slotRadio ( );

private:
  void initMe                (  int );
  void setRegionCode         (  int );
  void changeRegion          ( uint );
  void changeSelectedRegion  ( uint );
  void resetColors           (      );
  void updatePixmap          ( uint );

private:
  RegionPreview *m_pPreview;

  QImage m_image; // Needed for mouse tracking
  QRgb   m_colors[2][7];
  uint   m_colorIdxToRegion[10];
  uint   m_iPreviousColorIdx;
  uint   m_iSelectedRegion;
};

#endif // DIALOGREGION_H

